/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.inventories;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.gui.inventory.InventoryGui;
import me.realized.duels.util.Loadable;
import me.realized.duels.util.gui.AbstractGui;
import me.realized.duels.util.gui.GuiListener;
import org.bukkit.entity.Player;

public class InventoryManager
implements Loadable {
    private final DuelsPlugin plugin;
    private final GuiListener<DuelsPlugin> guiListener;
    private final Map<UUID, InventoryGui> inventories = new HashMap<UUID, InventoryGui>();
    private int expireTask;

    public InventoryManager(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.guiListener = plugin.getGuiListener();
    }

    @Override
    public void handleLoad() {
        this.expireTask = this.plugin.doSyncRepeat(() -> {
            long now = System.currentTimeMillis();
            this.inventories.entrySet().removeIf(entry -> {
                if (now - ((InventoryGui)entry.getValue()).getCreation() >= 300000L) {
                    this.guiListener.removeGui((AbstractGui)entry.getValue());
                    return true;
                }
                return false;
            });
        }, 20L, 100L).getTaskId();
    }

    @Override
    public void handleUnload() {
        this.plugin.cancelTask(this.expireTask);
        this.inventories.clear();
    }

    public InventoryGui get(UUID uuid) {
        return this.inventories.get(uuid);
    }

    public void create(Player player, boolean dead) {
        InventoryGui gui = this.inventories.remove(player.getUniqueId());
        if (gui != null) {
            this.guiListener.removeGui(gui);
        }
        gui = new InventoryGui(this.plugin, player, dead);
        this.guiListener.addGui(gui);
        this.inventories.put(player.getUniqueId(), gui);
    }
}

