/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.hook.hooks.worldguard;

import java.util.List;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.config.Config;
import me.realized.duels.hook.hooks.worldguard.WorldGuard6Handler;
import me.realized.duels.hook.hooks.worldguard.WorldGuard7Handler;
import me.realized.duels.hook.hooks.worldguard.WorldGuardHandler;
import me.realized.duels.util.hook.PluginHook;
import me.realized.duels.util.reflect.ReflectionUtil;
import org.bukkit.entity.Player;

public class WorldGuardHook
extends PluginHook<DuelsPlugin> {
    public static final String NAME = "WorldGuard";
    private final Config config;
    private final WorldGuardHandler handler;

    public WorldGuardHook(DuelsPlugin plugin) {
        super(plugin, NAME);
        this.config = plugin.getConfiguration();
        this.handler = ReflectionUtil.getClassUnsafe("com.sk89q.worldguard.WorldGuard") != null ? new WorldGuard7Handler() : new WorldGuard6Handler();
    }

    public String findDuelZone(Player player) {
        if (!this.config.isDuelzoneEnabled()) {
            return null;
        }
        List<String> allowedRegions = this.config.getDuelzones();
        if (allowedRegions.isEmpty()) {
            return null;
        }
        return this.handler.findRegion(player, allowedRegions);
    }
}

