/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.hook.hooks;

import java.util.Arrays;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.util.Log;
import me.realized.duels.util.hook.PluginHook;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHook
extends PluginHook<DuelsPlugin> {
    public static final String NAME = "Vault";
    private Economy economy;

    public VaultHook(DuelsPlugin plugin) {
        super(plugin, NAME);
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (provider == null) {
            Log.warn("Found no available economy plugin that supports Vault. Money betting will not be available.");
            return;
        }
        this.economy = (Economy)provider.getProvider();
        Log.info("Using Economy Provider: " + this.economy.getClass().getName());
    }

    public boolean has(int amount, Player ... players) {
        if (this.economy == null) {
            return false;
        }
        for (Player player : players) {
            if (this.economy.has((OfflinePlayer)player, (double)amount)) continue;
            return false;
        }
        return true;
    }

    public void add(int amount, Player ... players) {
        if (this.economy != null) {
            Arrays.stream(players).forEach(player -> this.economy.depositPlayer((OfflinePlayer)player, (double)amount));
        }
    }

    public void remove(int amount, Player ... players) {
        if (this.economy != null) {
            Arrays.stream(players).forEach(player -> this.economy.withdrawPlayer((OfflinePlayer)player, (double)amount));
        }
    }

    public Economy getEconomy() {
        return this.economy;
    }
}

