/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.hook.hooks;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.config.Config;
import me.realized.duels.util.hook.PluginHook;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class McMMOHook
extends PluginHook<DuelsPlugin> {
    public static final String NAME = "mcMMO";
    private final Config config;
    private final Map<UUID, PermissionAttachment> attachments = new HashMap<UUID, PermissionAttachment>();

    public McMMOHook(DuelsPlugin plugin) {
        super(plugin, NAME);
        this.config = plugin.getConfiguration();
    }

    public void disableSkills(Player player) {
        if (!this.config.isDisableSkills()) {
            return;
        }
        PermissionAttachment attachment = this.attachments.computeIfAbsent(player.getUniqueId(), result -> player.addAttachment((Plugin)this.plugin));
        attachment.setPermission("mcmmo.skills.*", false);
        player.recalculatePermissions();
    }

    public void enableSkills(Player player) {
        if (!this.config.isDisableSkills()) {
            return;
        }
        PermissionAttachment attachment = this.attachments.remove(player.getUniqueId());
        if (attachment == null) {
            return;
        }
        attachment.remove();
    }
}

