/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.hook.hooks;

import java.util.Arrays;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.config.Config;
import me.realized.duels.data.UserData;
import me.realized.duels.data.UserManagerImpl;
import me.realized.duels.util.hook.PluginHook;
import me.robin.leaderheads.datacollectors.OnlineDataCollector;
import me.robin.leaderheads.objects.BoardType;
import org.bukkit.entity.Player;

public class LeaderHeadsHook
extends PluginHook<DuelsPlugin> {
    public static final String NAME = "LeaderHeads";
    private final Config config;
    private final UserManagerImpl userManager;

    public LeaderHeadsHook(DuelsPlugin plugin) {
        super(plugin, NAME);
        this.config = plugin.getConfiguration();
        this.userManager = plugin.getUserManager();
        plugin.doSyncAfter(() -> {
            new DuelWinsCollector(this.config.getLhWinsTitle(), this.config.getLhWinsCmd());
            new DuelLossesCollector(this.config.getLhLossesTitle(), this.config.getLhLossesCmd());
        }, 1L);
    }

    public class DuelLossesCollector
    extends OnlineDataCollector {
        DuelLossesCollector(String title, String command) {
            super("duels-losses", "Duels", BoardType.DEFAULT, title, command, Arrays.asList(null, null, null, null));
        }

        public Double getScore(Player player) {
            UserData user = LeaderHeadsHook.this.userManager.get(player);
            return user != null ? (double)user.getLosses() : 0.0;
        }
    }

    public class DuelWinsCollector
    extends OnlineDataCollector {
        DuelWinsCollector(String title, String command) {
            super("duels-wins", "Duels", BoardType.DEFAULT, title, command, Arrays.asList(null, null, null, null));
        }

        public Double getScore(Player player) {
            UserData user = LeaderHeadsHook.this.userManager.get(player);
            return user != null ? (double)user.getWins() : 0.0;
        }
    }
}

