/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.hook.hooks;

import me.realized.duels.DuelsPlugin;
import me.realized.duels.arena.ArenaManagerImpl;
import me.realized.duels.config.Config;
import me.realized.duels.util.hook.PluginHook;
import net.minelink.ctplus.CombatTagPlus;
import net.minelink.ctplus.event.PlayerCombatTagEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class CombatTagPlusHook
extends PluginHook<DuelsPlugin> {
    public static final String NAME = "CombatTagPlus";
    private final Config config;
    private final ArenaManagerImpl arenaManager;

    public CombatTagPlusHook(DuelsPlugin plugin) {
        super(plugin, NAME);
        this.config = plugin.getConfiguration();
        this.arenaManager = plugin.getArenaManager();
        Bukkit.getPluginManager().registerEvents((Listener)new CombatTagPlusListener(), (Plugin)plugin);
    }

    public boolean isTagged(Player player) {
        return this.config.isCtpPreventDuel() && ((CombatTagPlus)this.getPlugin()).getTagManager().isTagged(player.getUniqueId());
    }

    public class CombatTagPlusListener
    implements Listener {
        @EventHandler(ignoreCancelled=true)
        public void on(PlayerCombatTagEvent event) {
            if (!CombatTagPlusHook.this.config.isCtpPreventTag()) {
                return;
            }
            Player player = event.getPlayer();
            if (!CombatTagPlusHook.this.arenaManager.isInMatch(player)) {
                return;
            }
            event.setCancelled(true);
        }
    }
}

