/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.hook.hooks;

import com.SirBlobman.combatlogx.api.ICombatLogX;
import com.SirBlobman.combatlogx.api.event.PlayerPreTagEvent;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.arena.ArenaManagerImpl;
import me.realized.duels.config.Config;
import me.realized.duels.util.hook.PluginHook;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class CombatLogXHook
extends PluginHook<DuelsPlugin> {
    public static final String NAME = "CombatLogX";
    private final Config config;
    private final ArenaManagerImpl arenaManager;

    public CombatLogXHook(DuelsPlugin plugin) {
        super(plugin, NAME);
        this.config = plugin.getConfiguration();
        this.arenaManager = plugin.getArenaManager();
        try {
            Class.forName("com.SirBlobman.combatlogx.api.event.PlayerPreTagEvent");
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("This version of " + this.getName() + " is not supported. Please try upgrading to the latest version.");
        }
        Bukkit.getPluginManager().registerEvents((Listener)new CombatLogXListener(), (Plugin)plugin);
    }

    public boolean isTagged(Player player) {
        return this.config.isClxPreventDuel() && ((ICombatLogX)this.getPlugin()).getCombatManager().isInCombat(player);
    }

    public class CombatLogXListener
    implements Listener {
        @EventHandler(ignoreCancelled=true)
        public void on(PlayerPreTagEvent event) {
            if (!CombatLogXHook.this.config.isClxPreventTag()) {
                return;
            }
            Player player = event.getPlayer();
            if (!CombatLogXHook.this.arenaManager.isInMatch(player)) {
                return;
            }
            event.setCancelled(true);
        }
    }
}

