/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.hook.hooks;

import me.realized.duels.DuelsPlugin;
import me.realized.duels.arena.ArenaManagerImpl;
import me.realized.duels.config.Config;
import me.realized.duels.util.hook.PluginHook;
import net.Indyuce.bountyhunters.api.event.BountyClaimEvent;
import net.Indyuce.bountyhunters.api.event.BountyCreateEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class BountyHuntersHook
extends PluginHook<DuelsPlugin>
implements Listener {
    public static final String NAME = "BountyHunters";
    private final Config config;
    private final ArenaManagerImpl arenaManager;

    public BountyHuntersHook(DuelsPlugin plugin) {
        super(plugin, NAME);
        this.config = plugin.getConfiguration();
        this.arenaManager = plugin.getArenaManager();
        try {
            Class.forName("net.Indyuce.bountyhunters.api.event.BountyClaimEvent");
            Class.forName("net.Indyuce.bountyhunters.api.event.BountyCreateEvent");
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("This version of " + this.getName() + " is not supported. Please try upgrading to the latest version.");
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void on(BountyClaimEvent event) {
        if (!this.config.isPreventBountyLoss() || !this.arenaManager.isInMatch(event.getClaimer())) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void on(BountyCreateEvent event) {
        Player target = event.getBounty().getTarget().getPlayer();
        if (!this.config.isPreventBountyLoss() || target == null || !this.arenaManager.isInMatch(target)) {
            return;
        }
        event.setCancelled(true);
    }
}

