/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.gui.settings.buttons;

import me.realized.duels.DuelsPlugin;
import me.realized.duels.gui.BaseButton;
import me.realized.duels.setting.Settings;
import me.realized.duels.util.inventory.ItemBuilder;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class KitSelectButton
extends BaseButton {
    public KitSelectButton(DuelsPlugin plugin) {
        super(plugin, ItemBuilder.of(Material.DIAMOND_SWORD).name(plugin.getLang().getMessage("GUI.settings.buttons.kit-selector.name")).build());
    }

    @Override
    public void update(Player player) {
        if (this.config.isKitSelectingUsePermission() && !player.hasPermission("duels.use.kit-select") && !player.hasPermission("duels.use.*")) {
            this.setLore(this.lang.getMessage("GUI.settings.buttons.kit-selector.lore-no-permission").split("\n"));
            return;
        }
        Settings settings = this.settingManager.getSafely(player);
        String kit = settings.getKit() != null ? settings.getKit().getName() : this.lang.getMessage("GENERAL.not-selected");
        String lore = this.lang.getMessage("GUI.settings.buttons.kit-selector.lore", "kit", kit);
        this.setLore(lore.split("\n"));
    }

    @Override
    public void onClick(Player player) {
        if (this.config.isKitSelectingUsePermission() && !player.hasPermission("duels.use.kit-select") && !player.hasPermission("duels.use.*")) {
            this.lang.sendMessage((CommandSender)player, "ERROR.no-permission", "permission", "duels.use.kit-select");
            return;
        }
        this.kitManager.getGui().open(player);
    }
}

