/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.gui.settings.buttons;

import me.realized.duels.DuelsPlugin;
import me.realized.duels.gui.BaseButton;
import me.realized.duels.setting.Settings;
import me.realized.duels.util.inventory.ItemBuilder;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ItemBettingButton
extends BaseButton {
    public ItemBettingButton(DuelsPlugin plugin) {
        super(plugin, ItemBuilder.of(Material.DIAMOND).name(plugin.getLang().getMessage("GUI.settings.buttons.item-betting.name")).build());
    }

    @Override
    public void update(Player player) {
        if (this.config.isItemBettingUsePermission() && !player.hasPermission("duels.use.item-betting") && !player.hasPermission("duels.use.*")) {
            this.setLore(this.lang.getMessage("GUI.settings.buttons.item-betting.lore-no-permission").split("\n"));
            return;
        }
        Settings settings = this.settingManager.getSafely(player);
        String itemBetting = settings.isItemBetting() ? this.lang.getMessage("GENERAL.enabled") : this.lang.getMessage("GENERAL.disabled");
        String lore = ((DuelsPlugin)this.plugin).getLang().getMessage("GUI.settings.buttons.item-betting.lore", "item_betting", itemBetting);
        this.setLore(lore.split("\n"));
    }

    @Override
    public void onClick(Player player) {
        Settings settings;
        if (this.config.isItemBettingUsePermission() && !player.hasPermission("duels.use.item-betting") && !player.hasPermission("duels.use.*")) {
            this.lang.sendMessage((CommandSender)player, "ERROR.no-permission", "permission", "duels.use.item-betting");
            return;
        }
        settings.setItemBetting(!(settings = this.settingManager.getSafely(player)).isItemBetting());
        settings.updateGui(player);
    }
}

