/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.gui.settings.buttons;

import me.realized.duels.DuelsPlugin;
import me.realized.duels.gui.BaseButton;
import me.realized.duels.setting.Settings;
import me.realized.duels.util.compat.Items;
import me.realized.duels.util.inventory.ItemBuilder;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ArenaSelectButton
extends BaseButton {
    public ArenaSelectButton(DuelsPlugin plugin) {
        super(plugin, ItemBuilder.of(Items.EMPTY_MAP).name(plugin.getLang().getMessage("GUI.settings.buttons.arena-selector.name")).build());
    }

    @Override
    public void update(Player player) {
        if (this.config.isArenaSelectingUsePermission() && !player.hasPermission("duels.use.arena-select") && !player.hasPermission("duels.use.*")) {
            this.setLore(this.lang.getMessage("GUI.settings.buttons.arena-selector.lore-no-permission").split("\n"));
            return;
        }
        Settings settings = this.settingManager.getSafely(player);
        String arena = settings.getArena() != null ? settings.getArena().getName() : this.lang.getMessage("GENERAL.random");
        String lore = this.lang.getMessage("GUI.settings.buttons.arena-selector.lore", "arena", arena);
        this.setLore(lore.split("\n"));
    }

    @Override
    public void onClick(Player player) {
        if (this.config.isArenaSelectingUsePermission() && !player.hasPermission("duels.use.arena-select") && !player.hasPermission("duels.use.*")) {
            this.lang.sendMessage((CommandSender)player, "ERROR.no-permission", "permission", "duels.use.arena-select");
            return;
        }
        this.arenaManager.getGui().open(player);
    }
}

