/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.gui.settings;

import java.util.ArrayList;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.config.Config;
import me.realized.duels.gui.BaseButton;
import me.realized.duels.gui.settings.buttons.ArenaSelectButton;
import me.realized.duels.gui.settings.buttons.CancelButton;
import me.realized.duels.gui.settings.buttons.ItemBettingButton;
import me.realized.duels.gui.settings.buttons.KitSelectButton;
import me.realized.duels.gui.settings.buttons.OwnInventoryButton;
import me.realized.duels.gui.settings.buttons.RequestDetailsButton;
import me.realized.duels.gui.settings.buttons.RequestSendButton;
import me.realized.duels.util.compat.Items;
import me.realized.duels.util.gui.Button;
import me.realized.duels.util.gui.SinglePageGui;
import me.realized.duels.util.inventory.Slots;
import org.bukkit.inventory.ItemStack;

public class SettingsGui
extends SinglePageGui<DuelsPlugin> {
    private static final int[][] PATTERNS = new int[][]{{13}, {12, 14}, {12, 13, 14}, {12, 13, 14, 22}};

    public SettingsGui(DuelsPlugin plugin) {
        super(plugin, plugin.getLang().getMessage("GUI.settings.title"), 3);
        Config config = plugin.getConfiguration();
        ItemStack spacing = Items.from(config.getSettingsFillerType(), config.getSettingsFillerData());
        Slots.run(2, 7, slot -> this.inventory.setItem(slot.intValue(), spacing));
        Slots.run(11, 16, slot -> this.inventory.setItem(slot.intValue(), spacing));
        Slots.run(20, 25, slot -> this.inventory.setItem(slot.intValue(), spacing));
        this.set(4, new RequestDetailsButton(plugin));
        ArrayList<BaseButton> buttons = new ArrayList<BaseButton>();
        if (config.isKitSelectingEnabled()) {
            buttons.add(new KitSelectButton(plugin));
        }
        if (config.isOwnInventoryEnabled()) {
            buttons.add(new OwnInventoryButton(plugin));
        }
        if (config.isArenaSelectingEnabled()) {
            buttons.add(new ArenaSelectButton(plugin));
        }
        if (config.isItemBettingEnabled()) {
            buttons.add(new ItemBettingButton(plugin));
        }
        if (!buttons.isEmpty()) {
            int[] pattern = PATTERNS[buttons.size() - 1];
            for (int i = 0; i < buttons.size(); ++i) {
                this.set(pattern[i], (Button)buttons.get(i));
            }
        }
        this.set(0, 2, 3, new RequestSendButton(plugin));
        this.set(7, 9, 3, new CancelButton(plugin));
    }
}

