/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.gui.options.buttons;

import java.util.ArrayList;
import java.util.Collections;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.gui.BaseButton;
import me.realized.duels.gui.options.OptionsGui;
import me.realized.duels.kit.KitImpl;
import me.realized.duels.util.inventory.ItemBuilder;
import org.bukkit.entity.Player;

public class OptionButton
extends BaseButton {
    private final OptionsGui gui;
    private final KitImpl kit;
    private final OptionsGui.Option option;

    public OptionButton(DuelsPlugin plugin, OptionsGui gui, KitImpl kit, OptionsGui.Option option) {
        super(plugin, ItemBuilder.of(option.getDisplayed()).build());
        this.gui = gui;
        this.kit = kit;
        this.option = option;
        this.setDisplayName(plugin.getLang().getMessage("GUI.options.buttons.option.name", "name", option.name().toLowerCase()));
        this.update();
    }

    private void update() {
        boolean state = this.option.get(this.kit);
        this.setGlow(state);
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : this.option.getDescription()) {
            lore.add("&f" + line.replace("%kit%", this.kit.getName()));
        }
        Collections.addAll(lore, this.lang.getMessage("GUI.options.buttons.option.lore", "state", state ? this.lang.getMessage("GENERAL.enabled") : this.lang.getMessage("GENERAL.disabled")).split("\n"));
        this.setLore(lore);
    }

    @Override
    public void onClick(Player player) {
        this.option.set(this.kit);
        this.update();
        this.gui.update(player, this);
    }
}

