/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.gui.options;

import java.util.function.Consumer;
import java.util.function.Function;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.gui.options.buttons.OptionButton;
import me.realized.duels.kit.KitImpl;
import me.realized.duels.util.compat.Items;
import me.realized.duels.util.gui.SinglePageGui;
import me.realized.duels.util.inventory.Slots;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class OptionsGui
extends SinglePageGui<DuelsPlugin> {
    private final DuelsPlugin plugin;
    private final Player owner;

    public OptionsGui(DuelsPlugin plugin, Player player, KitImpl kit) {
        super(plugin, plugin.getLang().getMessage("GUI.options.title", "kit", kit.getName()), 2);
        this.plugin = plugin;
        this.owner = player;
        int i = 0;
        for (Option option : Option.values()) {
            this.set(i++, new OptionButton(plugin, this, kit, option));
        }
        ItemStack spacing = Items.WHITE_PANE.clone();
        Slots.run(9, 18, slot -> this.inventory.setItem(slot.intValue(), spacing));
    }

    @Override
    public void on(Player player, Inventory inventory, InventoryCloseEvent event) {
        this.plugin.getGuiListener().removeGui(this.owner, this);
    }

    public static enum Option {
        USEPERMISSION(Material.BARRIER, KitImpl::isUsePermission, kit -> kit.setUsePermission(!kit.isUsePermission()), "When enabled, players must", "have the permission duels.kits.%kit%", "to select this kit for duel."),
        ARENASPECIFIC(Items.EMPTY_MAP, KitImpl::isArenaSpecific, kit -> kit.setArenaSpecific(!kit.isArenaSpecific()), "When enabled, kit %kit%", "can only be used in", "arenas it is bound to."),
        SOUP(Items.MUSHROOM_SOUP, KitImpl.Characteristic.SOUP, "When enabled, players will", "receive the amount of health", "defined in config when", "right-clicking a soup."),
        SUMO(Material.SLIME_BALL, KitImpl.Characteristic.SUMO, "When enabled, players will ", "lose health only when", "interacting with water or lava."),
        UHC(Material.GOLDEN_APPLE, KitImpl.Characteristic.UHC, "When enabled, player's health", "will not naturally regenerate."),
        COMBO(Material.IRON_SWORD, KitImpl.Characteristic.COMBO, "When enabled, players will", "have no delay between hits.");

        private final Material displayed;
        private final String[] description;
        private final Function<KitImpl, Boolean> getter;
        private final Consumer<KitImpl> setter;

        private Option(Material displayed, Function<KitImpl, Boolean> getter, Consumer<KitImpl> setter, String ... description) {
            this.displayed = displayed;
            this.description = description;
            this.getter = getter;
            this.setter = setter;
        }

        private Option(Material displayed, KitImpl.Characteristic characteristic, String ... description) {
            this.displayed = displayed;
            this.description = description;
            this.getter = kit -> kit.hasCharacteristic(characteristic);
            this.setter = kit -> kit.toggleCharacteristic(characteristic);
        }

        public boolean get(KitImpl kit) {
            return this.getter.apply(kit);
        }

        public void set(KitImpl kit) {
            this.setter.accept(kit);
        }

        public Material getDisplayed() {
            return this.displayed;
        }

        public String[] getDescription() {
            return this.description;
        }
    }
}

