/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.gui.inventory;

import me.realized.duels.DuelsPlugin;
import me.realized.duels.gui.inventory.buttons.EffectsButton;
import me.realized.duels.gui.inventory.buttons.HeadButton;
import me.realized.duels.gui.inventory.buttons.HealthButton;
import me.realized.duels.gui.inventory.buttons.HungerButton;
import me.realized.duels.gui.inventory.buttons.PotionCounterButton;
import me.realized.duels.util.compat.Items;
import me.realized.duels.util.gui.SinglePageGui;
import me.realized.duels.util.inventory.Slots;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class InventoryGui
extends SinglePageGui<DuelsPlugin> {
    public InventoryGui(DuelsPlugin plugin, Player player, boolean dead) {
        super(plugin, plugin.getLang().getMessage("GUI.inventory-view.title", "name", player.getName()), 6);
        ItemStack spacing = Items.GRAY_PANE.clone();
        Slots.run(0, 9, slot -> this.inventory.setItem(slot.intValue(), spacing));
        this.set(4, new HeadButton(plugin, player));
        int potions = 0;
        int slot2 = 9;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item != null && item.getType() != Material.AIR) {
                if (Items.isHealSplash(item)) {
                    ++potions;
                }
                this.inventory.setItem(slot2, item.clone());
            }
            ++slot2;
        }
        slot2 = 48;
        for (ItemStack item : player.getInventory().getArmorContents()) {
            if (item != null && item.getType() != Material.AIR) {
                this.inventory.setItem(slot2, item.clone());
            }
            --slot2;
        }
        this.inventory.setItem(49, spacing);
        this.set(50, new PotionCounterButton(plugin, potions));
        this.set(51, new EffectsButton(plugin, player));
        this.set(52, new HungerButton(plugin, player));
        this.set(53, new HealthButton(plugin, player, dead));
    }
}

