/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.gui.bind.buttons;

import java.util.stream.Collectors;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.arena.ArenaImpl;
import me.realized.duels.gui.BaseButton;
import me.realized.duels.gui.bind.BindGui;
import me.realized.duels.kit.KitImpl;
import me.realized.duels.util.StringUtil;
import me.realized.duels.util.compat.Items;
import me.realized.duels.util.inventory.ItemBuilder;
import org.bukkit.entity.Player;

public class BindButton
extends BaseButton {
    private BindGui gui;
    private final KitImpl kit;
    private final ArenaImpl arena;

    public BindButton(DuelsPlugin plugin, KitImpl kit, ArenaImpl arena) {
        super(plugin, ItemBuilder.of(Items.EMPTY_MAP).build());
        this.kit = kit;
        this.arena = arena;
        this.setDisplayName(plugin.getLang().getMessage("GUI.bind.buttons.arena.name", "arena", arena.getName()));
        this.update();
    }

    private void update() {
        boolean state = this.arena.isBound(this.kit);
        this.setGlow(state);
        String kits = StringUtil.join(this.arena.getKits().stream().map(KitImpl::getName).collect(Collectors.toList()), ", ");
        kits = kits.isEmpty() ? this.lang.getMessage("GENERAL.none") : kits;
        this.setLore(this.lang.getMessage("GUI.bind.buttons.arena.lore-" + (state ? "bound" : "not-bound"), "kits", kits).split("\n"));
    }

    @Override
    public void onClick(Player player) {
        this.arena.bind(this.kit);
        this.update();
        this.gui.calculatePages();
    }

    public void setGui(BindGui gui) {
        this.gui = gui;
    }
}

