/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.gui.betting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.duel.DuelManager;
import me.realized.duels.gui.betting.buttons.CancelButton;
import me.realized.duels.gui.betting.buttons.DetailsButton;
import me.realized.duels.gui.betting.buttons.HeadButton;
import me.realized.duels.gui.betting.buttons.StateButton;
import me.realized.duels.setting.Settings;
import me.realized.duels.util.compat.CompatUtil;
import me.realized.duels.util.compat.Items;
import me.realized.duels.util.gui.AbstractGui;
import me.realized.duels.util.gui.Button;
import me.realized.duels.util.gui.GuiListener;
import me.realized.duels.util.inventory.InventoryBuilder;
import me.realized.duels.util.inventory.InventoryUtil;
import me.realized.duels.util.inventory.Slots;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BettingGui
extends AbstractGui<DuelsPlugin> {
    private final Section[] sections = new Section[]{new Section(9, 13, 4), new Section(14, 18, 4)};
    private final GuiListener<DuelsPlugin> guiListener;
    private final DuelManager duelManager;
    private final Settings settings;
    private final Inventory inventory;
    private final UUID first;
    private final UUID second;
    private boolean firstReady;
    private boolean secondReady;
    private boolean waitDone;
    private boolean cancelWait;

    public BettingGui(DuelsPlugin plugin, Settings settings, Player first, Player second) {
        super(plugin);
        this.guiListener = plugin.getGuiListener();
        this.duelManager = plugin.getDuelManager();
        this.settings = settings;
        this.inventory = InventoryBuilder.of(plugin.getLang().getMessage("GUI.item-betting.title"), 54).build();
        this.first = first.getUniqueId();
        this.second = second.getUniqueId();
        this.set(this.inventory, 13, 14, 5, new CancelButton(plugin));
        Slots.run(0, 3, slot -> this.inventory.setItem(slot.intValue(), Items.ORANGE_PANE.clone()));
        Slots.run(45, 48, slot -> this.inventory.setItem(slot.intValue(), Items.ORANGE_PANE.clone()));
        Slots.run(6, 9, slot -> this.inventory.setItem(slot.intValue(), Items.BLUE_PANE.clone()));
        Slots.run(51, 54, slot -> this.inventory.setItem(slot.intValue(), Items.BLUE_PANE.clone()));
        this.set(this.inventory, 3, new StateButton(plugin, this, first));
        this.set(this.inventory, 4, new DetailsButton(plugin, settings));
        this.set(this.inventory, 5, new StateButton(plugin, this, second));
        this.set(this.inventory, 48, new HeadButton(plugin, first));
        this.set(this.inventory, 50, new HeadButton(plugin, second));
    }

    private boolean isFirst(Player player) {
        return player.getUniqueId().equals(this.first);
    }

    private Section getSection(Player player) {
        return this.isFirst(player) ? this.sections[0] : this.sections[1];
    }

    public boolean isReady(Player player) {
        return this.isFirst(player) ? this.firstReady : this.secondReady;
    }

    public void setReady(Player player) {
        if (this.isFirst(player)) {
            this.firstReady = true;
        } else {
            this.secondReady = true;
        }
        if (this.firstReady && this.secondReady) {
            new WaitTask().runTaskTimer((Plugin)this.plugin, 10L, 20L);
        }
    }

    public void update(Player player, Button<DuelsPlugin> button) {
        this.update(player, this.inventory, button);
    }

    @Override
    public void open(Player ... players) {
        for (Player player : players) {
            this.update(player);
            player.openInventory(this.inventory);
        }
    }

    @Override
    public boolean isPart(Inventory inventory) {
        return inventory.equals(this.inventory);
    }

    @Override
    public void on(Player player, Inventory top, InventoryClickEvent event) {
        Inventory clicked = event.getClickedInventory();
        if (clicked == null) {
            return;
        }
        Button button = this.get(this.inventory, event.getSlot());
        if (this.firstReady && this.secondReady && !(button instanceof CancelButton)) {
            event.setCancelled(true);
            return;
        }
        int slot = event.getSlot();
        if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY || event.getAction() == InventoryAction.COLLECT_TO_CURSOR) {
            event.setCancelled(true);
            return;
        }
        if (!clicked.equals(top)) {
            return;
        }
        Section section = this.getSection(player);
        if (section == null) {
            return;
        }
        if (!this.isReady(player) && section.isPart(slot)) {
            return;
        }
        event.setCancelled(true);
        if (button == null) {
            return;
        }
        button.onClick(player);
    }

    @Override
    public void on(Player player, Set<Integer> rawSlots, InventoryDragEvent event) {
        Section section = this.getSection(player);
        if (section == null) {
            return;
        }
        boolean in = false;
        boolean out = false;
        boolean outSec = false;
        for (int slot : rawSlots) {
            if (slot > 53) {
                out = true;
                continue;
            }
            if (!section.isPart(slot)) {
                outSec = true;
            }
            in = true;
        }
        if (in && (this.isReady(player) || out || outSec)) {
            event.setCancelled(true);
        }
    }

    @Override
    public void on(Player player, Inventory inventory, InventoryCloseEvent event) {
        if (this.waitDone) {
            return;
        }
        this.cancelWait = true;
        InventoryUtil.addOrDrop(player, this.getSection(player).collect());
        this.guiListener.removeGui(player, this);
        Player other = Bukkit.getPlayer((UUID)(this.first.equals(player.getUniqueId()) ? this.second : this.first));
        if (other != null) {
            ((DuelsPlugin)this.plugin).doSync(() -> {
                if (inventory.getViewers().contains(other)) {
                    other.closeInventory();
                }
            });
        }
    }

    @Override
    public void clear() {
        Player first = Bukkit.getPlayer((UUID)this.first);
        Player second = Bukkit.getPlayer((UUID)this.second);
        if (first != null && second != null) {
            InventoryUtil.addOrDrop(first, this.getSection(first).collect());
            InventoryUtil.addOrDrop(second, this.getSection(second).collect());
        }
        super.clear();
    }

    private class WaitTask
    extends BukkitRunnable {
        private static final int SLOT_START = 13;
        private int counter;

        private WaitTask() {
        }

        public void run() {
            if (BettingGui.this.cancelWait) {
                this.cancel();
                return;
            }
            if (this.counter < 5) {
                int slot = 13 + 9 * this.counter;
                ItemStack item = BettingGui.this.inventory.getItem(slot);
                if (CompatUtil.isPre1_13()) {
                    item.setDurability((short)5);
                } else {
                    ItemStack greenPane = Items.GREEN_PANE.clone();
                    greenPane.setItemMeta(item.getItemMeta());
                    item = greenPane;
                }
                BettingGui.this.inventory.setItem(slot, item);
                ++this.counter;
                return;
            }
            this.cancel();
            BettingGui.this.waitDone = true;
            Player first = Bukkit.getPlayer((UUID)BettingGui.this.first);
            Player second = Bukkit.getPlayer((UUID)BettingGui.this.second);
            if (first == null || second == null) {
                return;
            }
            first.closeInventory();
            second.closeInventory();
            HashMap<UUID, List<ItemStack>> items = new HashMap<UUID, List<ItemStack>>();
            items.put(first.getUniqueId(), BettingGui.this.getSection(first).collect());
            items.put(second.getUniqueId(), BettingGui.this.getSection(second).collect());
            BettingGui.this.guiListener.removeGui(first, BettingGui.this);
            BettingGui.this.guiListener.removeGui(second, BettingGui.this);
            BettingGui.this.duelManager.startMatch(first, second, BettingGui.this.settings, items, null);
        }
    }

    private class Section {
        private final int start;
        private final int end;
        private final int height;

        Section(int start, int end, int height) {
            this.start = start;
            this.end = end;
            this.height = height;
        }

        private boolean isPart(int slot) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = this.start; x < this.end; ++x) {
                    if (x + y * 9 != slot) continue;
                    return true;
                }
            }
            return false;
        }

        private List<ItemStack> collect() {
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            Slots.run(this.start, this.end, this.height, slot -> {
                ItemStack item = BettingGui.this.inventory.getItem(slot.intValue());
                if (item != null && item.getType() != Material.AIR) {
                    result.add(item);
                    BettingGui.this.inventory.setItem(slot.intValue(), null);
                }
            });
            return result;
        }
    }
}

