/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.extension;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.api.Duels;
import me.realized.duels.api.extension.DuelsExtension;
import me.realized.duels.extension.ExtensionClassLoader;
import me.realized.duels.extension.ExtensionInfo;
import me.realized.duels.util.Loadable;
import me.realized.duels.util.Log;
import me.realized.duels.util.NumberUtil;
import org.bukkit.Bukkit;

public class ExtensionManager
implements Loadable {
    private static Method INIT_EXTENSION;
    private final Map<String, DuelsExtension> extensions = new HashMap<String, DuelsExtension>();
    private final Map<DuelsExtension, ExtensionInfo> info = new HashMap<DuelsExtension, ExtensionInfo>();
    private final DuelsPlugin plugin;
    private final File folder;

    public ExtensionManager(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.folder = new File(plugin.getDataFolder(), "extensions");
        if (!this.folder.exists()) {
            this.folder.mkdir();
        }
    }

    @Override
    public void handleLoad() {
        File[] jars = this.folder.listFiles((dir, name) -> name.endsWith(".jar"));
        if (jars == null) {
            return;
        }
        for (File file : jars) {
            try {
                ExtensionInfo info = new ExtensionInfo(file);
                if (this.extensions.containsKey(info.getName())) {
                    Log.error(this, "Could not load extension " + file.getName() + ": An extension with the name '" + info.getName() + "' already exists");
                    continue;
                }
                if (!info.getDepends().isEmpty() && info.getDepends().stream().anyMatch(depend -> !Bukkit.getPluginManager().isPluginEnabled(depend))) {
                    Log.error(this, "Could not load extension " + file.getName() + ": This extension require the following plugins to enable - " + info.getDepends());
                    continue;
                }
                if (info.getApiVersion() != null && NumberUtil.isLower(this.plugin.getVersion(), info.getApiVersion())) {
                    Log.error(this, "Could not load extension " + file.getName() + ": This extension requires Duels v" + info.getApiVersion() + " or higher!");
                    continue;
                }
                ExtensionClassLoader classLoader = new ExtensionClassLoader(file, info, DuelsExtension.class.getClassLoader());
                DuelsExtension extension = classLoader.getExtension();
                if (extension == null) {
                    Log.error(this, "Could not load extension " + file.getName() + ": Failed to initiate main class");
                    continue;
                }
                String requiredVersion = extension.getRequiredVersion();
                if (requiredVersion != null && NumberUtil.isLower(this.plugin.getVersion(), requiredVersion)) {
                    Log.error(this, "Could not load extension " + file.getName() + ": This extension requires Duels v" + requiredVersion + " or higher!");
                    continue;
                }
                INIT_EXTENSION.invoke((Object)extension, this.plugin, info.getName(), this.folder, file);
                extension.setEnabled(true);
                Log.info(this, "Extension '" + extension.getName() + " " + info.getVersion() + "' is now enabled.");
                this.extensions.put(extension.getName(), extension);
                this.info.put(extension, info);
            }
            catch (Throwable thrown) {
                Log.error(this, "Could not enable extension " + file.getName() + "!", thrown);
            }
        }
    }

    @Override
    public void handleUnload() {
        this.extensions.values().forEach(extension -> {
            try {
                extension.setEnabled(false);
                ClassLoader classLoader = extension.getClass().getClassLoader();
                if (classLoader instanceof ExtensionClassLoader) {
                    ((ExtensionClassLoader)classLoader).close();
                }
                Log.info(this, "Extension '" + extension.getName() + "' is now disabled.");
            }
            catch (Exception ex) {
                Log.error(this, "Could not disable extension " + extension.getName() + "!", ex);
            }
        });
        this.extensions.clear();
        this.info.clear();
    }

    public DuelsExtension getExtension(String name) {
        return this.extensions.get(name);
    }

    public ExtensionInfo getInfo(DuelsExtension extension) {
        return this.info.get(extension);
    }

    static {
        try {
            INIT_EXTENSION = DuelsExtension.class.getDeclaredMethod("init", Duels.class, String.class, File.class, File.class);
            INIT_EXTENSION.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

