/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.duel;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.api.event.match.MatchEndEvent;
import me.realized.duels.api.event.match.MatchStartEvent;
import me.realized.duels.arena.ArenaImpl;
import me.realized.duels.arena.ArenaManagerImpl;
import me.realized.duels.arena.MatchImpl;
import me.realized.duels.config.Config;
import me.realized.duels.config.Lang;
import me.realized.duels.data.MatchData;
import me.realized.duels.data.UserData;
import me.realized.duels.data.UserManagerImpl;
import me.realized.duels.hook.hooks.CombatLogXHook;
import me.realized.duels.hook.hooks.CombatTagPlusHook;
import me.realized.duels.hook.hooks.EssentialsHook;
import me.realized.duels.hook.hooks.McMMOHook;
import me.realized.duels.hook.hooks.MyPetHook;
import me.realized.duels.hook.hooks.PvPManagerHook;
import me.realized.duels.hook.hooks.VaultHook;
import me.realized.duels.hook.hooks.worldguard.WorldGuardHook;
import me.realized.duels.inventories.InventoryManager;
import me.realized.duels.kit.KitImpl;
import me.realized.duels.player.PlayerInfo;
import me.realized.duels.player.PlayerInfoManager;
import me.realized.duels.queue.Queue;
import me.realized.duels.queue.QueueManager;
import me.realized.duels.setting.Settings;
import me.realized.duels.teleport.Teleport;
import me.realized.duels.util.Loadable;
import me.realized.duels.util.Log;
import me.realized.duels.util.NumberUtil;
import me.realized.duels.util.PlayerUtil;
import me.realized.duels.util.StringUtil;
import me.realized.duels.util.TextBuilder;
import me.realized.duels.util.compat.CompatUtil;
import me.realized.duels.util.compat.Titles;
import me.realized.duels.util.function.Pair;
import me.realized.duels.util.inventory.InventoryUtil;
import net.md_5.bungee.api.chat.ClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;

public class DuelManager
implements Loadable {
    private static final Calendar GREGORIAN_CALENDAR = new GregorianCalendar();
    private final DuelsPlugin plugin;
    private final Config config;
    private final Lang lang;
    private final UserManagerImpl userDataManager;
    private final ArenaManagerImpl arenaManager;
    private final PlayerInfoManager playerManager;
    private final InventoryManager inventoryManager;
    private QueueManager queueManager;
    private Teleport teleport;
    private CombatTagPlusHook combatTagPlus;
    private PvPManagerHook pvpManager;
    private CombatLogXHook combatLogX;
    private VaultHook vault;
    private EssentialsHook essentials;
    private McMMOHook mcMMO;
    private WorldGuardHook worldGuard;
    private MyPetHook myPet;
    private int durationCheckTask;

    public DuelManager(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.lang = plugin.getLang();
        this.userDataManager = plugin.getUserManager();
        this.arenaManager = plugin.getArenaManager();
        this.playerManager = plugin.getPlayerManager();
        this.inventoryManager = plugin.getInventoryManager();
        plugin.doSyncAfter(() -> Bukkit.getPluginManager().registerEvents((Listener)new DuelListener(), (Plugin)plugin), 1L);
    }

    @Override
    public void handleLoad() {
        this.queueManager = this.plugin.getQueueManager();
        this.teleport = this.plugin.getTeleport();
        this.combatTagPlus = this.plugin.getHookManager().getHook(CombatTagPlusHook.class);
        this.pvpManager = this.plugin.getHookManager().getHook(PvPManagerHook.class);
        this.combatLogX = this.plugin.getHookManager().getHook(CombatLogXHook.class);
        this.vault = this.plugin.getHookManager().getHook(VaultHook.class);
        this.essentials = this.plugin.getHookManager().getHook(EssentialsHook.class);
        this.mcMMO = this.plugin.getHookManager().getHook(McMMOHook.class);
        this.worldGuard = this.plugin.getHookManager().getHook(WorldGuardHook.class);
        this.myPet = this.plugin.getHookManager().getHook(MyPetHook.class);
        if (this.config.getMaxDuration() > 0) {
            this.durationCheckTask = this.plugin.doSyncRepeat(() -> {
                for (ArenaImpl arena : this.arenaManager.getArenasImpl()) {
                    MatchImpl match = arena.getMatch();
                    if (match == null || match.getDurationInMillis() < (long)(this.config.getMaxDuration() * 60) * 1000L || arena.size() <= 1) continue;
                    for (Player player : match.getAllPlayers()) {
                        this.handleTie(player, arena, match, true);
                        this.lang.sendMessage((CommandSender)player, "DUEL.on-end.tie", new Object[0]);
                    }
                    arena.endMatch(null, null, MatchEndEvent.Reason.MAX_TIME_REACHED);
                }
            }, 0L, 20L).getTaskId();
        }
    }

    @Override
    public void handleUnload() {
        this.plugin.cancelTask(this.durationCheckTask);
        for (ArenaImpl arena : this.arenaManager.getArenasImpl()) {
            boolean winnerDecided;
            MatchImpl match = arena.getMatch();
            if (match == null) continue;
            int size = arena.size();
            boolean bl = winnerDecided = size == 1;
            if (winnerDecided) {
                Player winner = arena.first();
                this.lang.sendMessage((CommandSender)winner, "DUEL.on-end.plugin-disable", new Object[0]);
                this.handleWin(winner, arena.getOpponent(winner), arena, match);
            } else {
                boolean ongoing = size > 1;
                for (Player player : match.getAllPlayers()) {
                    this.lang.sendMessage((CommandSender)player, "DUEL.on-end.plugin-disable", new Object[0]);
                    this.handleTie(player, arena, match, ongoing);
                }
            }
            arena.endMatch(null, null, MatchEndEvent.Reason.PLUGIN_DISABLE);
        }
    }

    private void handleTie(Player player, ArenaImpl arena, MatchImpl match, boolean alive) {
        arena.remove(player);
        if (this.vault != null && match.getBet() > 0) {
            this.vault.add(match.getBet(), player);
        }
        if (this.mcMMO != null) {
            this.mcMMO.enableSkills(player);
        }
        PlayerInfo info = this.playerManager.get(player);
        List<ItemStack> items = match.getItems(player);
        if (alive) {
            PlayerUtil.reset(player);
            this.playerManager.remove(player);
            if (info != null) {
                this.teleport.tryTeleport(player, info.getLocation());
                info.restore(player);
            } else {
                this.teleport.tryTeleport(player, this.playerManager.getLobby());
            }
            InventoryUtil.addOrDrop(player, items);
        } else if (info != null) {
            info.getExtra().addAll(items);
        } else {
            InventoryUtil.addOrDrop(player, items);
        }
    }

    private void handleWin(Player player, Player opponent, ArenaImpl arena, MatchImpl match) {
        String opponentName;
        arena.remove(player);
        String string = opponentName = opponent != null ? opponent.getName() : this.lang.getMessage("GENERAL.none");
        if (this.vault != null && match.getBet() > 0) {
            int amount = match.getBet() * 2;
            this.vault.add(amount, player);
            this.lang.sendMessage((CommandSender)player, "DUEL.reward.money.message", "name", opponentName, "money", amount);
            String title = this.lang.getMessage("DUEL.reward.money.title", "name", opponentName, "money", amount);
            if (title != null) {
                Titles.send(player, title, null, 0, 20, 50);
            }
        }
        if (this.mcMMO != null) {
            this.mcMMO.enableSkills(player);
        }
        PlayerInfo info = this.playerManager.get(player);
        List<ItemStack> items = match.getItems();
        if (!player.isDead()) {
            this.playerManager.remove(player);
            PlayerUtil.reset(player);
            if (info != null) {
                this.teleport.tryTeleport(player, info.getLocation());
                info.restore(player);
            }
            if (InventoryUtil.addOrDrop(player, items)) {
                this.lang.sendMessage((CommandSender)player, "DUEL.reward.items.message", "name", opponentName);
            }
        } else {
            info.getExtra().addAll(items);
        }
    }

    public void startMatch(Player first, Player second, Settings settings, Map<UUID, List<ItemStack>> items, Queue source) {
        ArenaImpl arena;
        KitImpl kit = settings.getKit();
        if (!settings.isOwnInventory() && kit == null) {
            this.lang.sendMessage(Arrays.asList(first, second), "DUEL.start-failure.mode-unselected", new Object[0]);
            this.refundItems(items, first, second);
            return;
        }
        if (first.isDead() || second.isDead()) {
            this.lang.sendMessage(Arrays.asList(first, second), "DUEL.start-failure.player-is-dead", new Object[0]);
            this.refundItems(items, first, second);
            return;
        }
        if (this.isBlacklistedWorld(first) || this.isBlacklistedWorld(second)) {
            this.lang.sendMessage(Arrays.asList(first, second), "DUEL.start-failure.in-blacklisted-world", new Object[0]);
            this.refundItems(items, first, second);
            return;
        }
        if (this.isTagged(first) || this.isTagged(second)) {
            this.lang.sendMessage(Arrays.asList(first, second), "DUEL.start-failure.is-tagged", new Object[0]);
            this.refundItems(items, first, second);
            return;
        }
        if (this.config.isCancelIfMoved() && (this.notInLoc(first, settings.getBaseLoc(first)) || this.notInLoc(second, settings.getBaseLoc(second)))) {
            this.lang.sendMessage(Arrays.asList(first, second), "DUEL.start-failure.player-moved", new Object[0]);
            this.refundItems(items, first, second);
            return;
        }
        if (this.config.isDuelzoneEnabled() && this.worldGuard != null && (this.notInDz(first, settings.getDuelzone(first)) || this.notInDz(second, settings.getDuelzone(second)))) {
            this.lang.sendMessage(Arrays.asList(first, second), "DUEL.start-failure.not-in-duelzone", new Object[0]);
            this.refundItems(items, first, second);
            return;
        }
        if (this.config.isPreventCreativeMode() && (first.getGameMode() == GameMode.CREATIVE || second.getGameMode() == GameMode.CREATIVE)) {
            this.lang.sendMessage(Arrays.asList(first, second), "DUEL.start-failure.in-creative-mode", new Object[0]);
            this.refundItems(items, first, second);
            return;
        }
        ArenaImpl arenaImpl = arena = settings.getArena() != null ? settings.getArena() : this.arenaManager.randomArena(kit);
        if (arena == null || !arena.isAvailable()) {
            this.lang.sendMessage(Arrays.asList(first, second), "DUEL.start-failure." + (settings.getArena() != null ? "arena-in-use" : "no-arena-available"), new Object[0]);
            this.refundItems(items, first, second);
            return;
        }
        if (kit != null && !this.arenaManager.isSelectable(kit, arena)) {
            this.lang.sendMessage(Arrays.asList(first, second), "DUEL.start-failure.arena-not-applicable", "kit", kit.getName(), "arena", arena.getName());
            this.refundItems(items, first, second);
            return;
        }
        int bet = settings.getBet();
        if (bet > 0 && this.vault != null && this.vault.getEconomy() != null) {
            if (!this.vault.has(bet, first, second)) {
                this.lang.sendMessage(Arrays.asList(first, second), "DUEL.start-failure.not-enough-money", "bet_amount", bet);
                this.refundItems(items, first, second);
                return;
            }
            this.vault.remove(bet, first, second);
        }
        MatchImpl match = arena.startMatch(kit, items, settings.getBet(), source);
        this.addPlayers(source, arena, kit, arena.getPositions(), first, second);
        if (this.config.isCdEnabled()) {
            HashMap<UUID, Pair<String, Integer>> info = new HashMap<UUID, Pair<String, Integer>>();
            info.put(first.getUniqueId(), new Pair<String, Integer>(second.getName(), this.getRating(kit, this.userDataManager.get(second))));
            info.put(second.getUniqueId(), new Pair<String, Integer>(first.getName(), this.getRating(kit, this.userDataManager.get(first))));
            arena.startCountdown(kit != null ? kit.getName() : this.lang.getMessage("GENERAL.none"), info);
        }
        MatchStartEvent event = new MatchStartEvent(match, first, second);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    private void refundItems(Map<UUID, List<ItemStack>> items, Player ... players) {
        if (items != null) {
            Arrays.stream(players).forEach(player -> InventoryUtil.addOrDrop(player, items.getOrDefault(player.getUniqueId(), Collections.emptyList())));
        }
    }

    private boolean isBlacklistedWorld(Player player) {
        return this.config.getBlacklistedWorlds().contains(player.getWorld().getName());
    }

    private boolean isTagged(Player player) {
        return this.combatTagPlus != null && this.combatTagPlus.isTagged(player) || this.pvpManager != null && this.pvpManager.isTagged(player) || this.combatLogX != null && this.combatLogX.isTagged(player);
    }

    private boolean notInLoc(Player player, Location location) {
        if (location == null) {
            return false;
        }
        Location source = player.getLocation();
        return !source.getWorld().equals(location.getWorld()) || source.getBlockX() != location.getBlockX() || source.getBlockY() != location.getBlockY() || source.getBlockZ() != location.getBlockZ();
    }

    private boolean notInDz(Player player, String duelzone) {
        return duelzone != null && !duelzone.equals(this.worldGuard.findDuelZone(player));
    }

    private int getRating(KitImpl kit, UserData user) {
        return user != null ? user.getRating(kit) : this.config.getDefaultRating();
    }

    private void addPlayers(Queue source, ArenaImpl arena, KitImpl kit, Map<Integer, Location> locations, Player ... players) {
        int position = 0;
        for (Player player : players) {
            if (source == null) {
                this.queueManager.remove(player);
            }
            if (player.getAllowFlight()) {
                player.setFlying(false);
                player.setAllowFlight(false);
            }
            player.closeInventory();
            this.playerManager.create(player);
            this.teleport.tryTeleport(player, locations.get(++position));
            if (kit != null) {
                PlayerUtil.reset(player);
                kit.equip(player);
            }
            if (this.config.isStartCommandsEnabled() && (source != null || !this.config.isStartCommandsQueueOnly())) {
                try {
                    for (String command : this.config.getStartCommands()) {
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("%player%", player.getName()));
                    }
                }
                catch (Exception ex) {
                    Log.warn(this, "Error while running match start commands: " + ex.getMessage());
                }
            }
            if (this.myPet != null) {
                this.myPet.removePet(player);
            }
            if (this.essentials != null) {
                this.essentials.tryUnvanish(player);
            }
            if (this.mcMMO != null) {
                this.mcMMO.disableSkills(player);
            }
            arena.add(player);
        }
    }

    private void handleInventories(MatchImpl match) {
        if (!this.config.isDisplayInventories()) {
            return;
        }
        String color = this.lang.getMessage("DUEL.inventories.name-color");
        TextBuilder builder = TextBuilder.of(this.lang.getMessage("DUEL.inventories.message"));
        Set<Player> players = match.getAllPlayers();
        Iterator<Player> iterator = players.iterator();
        while (iterator.hasNext()) {
            Player player = iterator.next();
            builder.add(StringUtil.color(color + player.getName()), ClickEvent.Action.RUN_COMMAND, "/duel _ " + player.getUniqueId());
            if (!iterator.hasNext()) continue;
            builder.add(StringUtil.color(color + ", "));
        }
        builder.send(players);
    }

    private void handleStats(MatchImpl match, UserData winner, UserData loser, MatchData matchData) {
        if (winner != null && loser != null) {
            String message;
            winner.addWin();
            loser.addLoss();
            winner.addMatch(matchData);
            loser.addMatch(matchData);
            KitImpl kit = match.getKit();
            int winnerRating = kit == null ? winner.getRating() : winner.getRating(kit);
            int loserRating = kit == null ? loser.getRating() : loser.getRating(kit);
            int change = 0;
            if (this.config.isRatingEnabled() && (match.isFromQueue() || !this.config.isRatingQueueOnly())) {
                change = NumberUtil.getChange(this.config.getKFactor(), winnerRating, loserRating);
                winner.setRating(kit, winnerRating += change);
                loser.setRating(kit, loserRating -= change);
            }
            if ((message = this.lang.getMessage("DUEL.on-end.opponent-defeat", "winner", winner.getName(), "loser", loser.getName(), "health", matchData.getHealth(), "kit", matchData.getKit(), "arena", match.getArena().getName(), "winner_rating", winnerRating, "loser_rating", loserRating, "change", change)) == null) {
                return;
            }
            if (this.config.isArenaOnlyEndMessage()) {
                match.getArena().broadcast(message);
            } else {
                Bukkit.getOnlinePlayers().forEach(player -> player.sendMessage(message));
            }
        }
    }

    private class DuelListener
    implements Listener {
        private DuelListener() {
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onLowest(PlayerDeathEvent event) {
            if (!DuelManager.this.arenaManager.isInMatch(event.getEntity())) {
                return;
            }
            event.getDrops().clear();
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void on(PlayerDeathEvent event) {
            Player player = event.getEntity();
            ArenaImpl arena = DuelManager.this.arenaManager.get(player);
            if (arena == null) {
                return;
            }
            if (DuelManager.this.mcMMO != null) {
                DuelManager.this.mcMMO.enableSkills(player);
            }
            event.setKeepLevel(true);
            event.setDroppedExp(0);
            event.setKeepInventory(false);
            DuelManager.this.inventoryManager.create(player, true);
            MatchImpl match = arena.getMatch();
            if (match == null) {
                return;
            }
            arena.remove(player);
            if (arena.size() <= 0) {
                return;
            }
            DuelManager.this.plugin.doSyncAfter(() -> {
                if (arena.size() == 0) {
                    match.getAllPlayers().forEach(matchPlayer -> {
                        DuelManager.this.handleTie(matchPlayer, arena, match, false);
                        DuelManager.this.lang.sendMessage((CommandSender)matchPlayer, "DUEL.on-end.tie", new Object[0]);
                    });
                    DuelManager.this.plugin.doSyncAfter(() -> DuelManager.this.handleInventories(match), 1L);
                    arena.endMatch(null, null, MatchEndEvent.Reason.TIE);
                    return;
                }
                Player winner = arena.first();
                DuelManager.this.inventoryManager.create(winner, false);
                if (DuelManager.this.config.isSpawnFirework()) {
                    Firework firework = (Firework)winner.getWorld().spawnEntity(winner.getEyeLocation(), EntityType.FIREWORK);
                    FireworkMeta meta = firework.getFireworkMeta();
                    meta.addEffect(FireworkEffect.builder().withColor(Color.RED).with(FireworkEffect.Type.BALL_LARGE).withTrail().build());
                    firework.setFireworkMeta(meta);
                }
                double health = Math.ceil(winner.getHealth()) * 0.5;
                String kitName = match.getKit() != null ? match.getKit().getName() : DuelManager.this.lang.getMessage("GENERAL.none");
                long duration = System.currentTimeMillis() - match.getStart();
                long time = GREGORIAN_CALENDAR.getTimeInMillis();
                MatchData matchData = new MatchData(winner.getName(), player.getName(), kitName, time, duration, health);
                DuelManager.this.handleStats(match, DuelManager.this.userDataManager.get(winner), DuelManager.this.userDataManager.get(player), matchData);
                DuelManager.this.plugin.doSyncAfter(() -> DuelManager.this.handleInventories(match), 1L);
                DuelManager.this.plugin.doSyncAfter(() -> {
                    DuelManager.this.handleWin(winner, player, arena, match);
                    if (DuelManager.this.config.isEndCommandsEnabled() && (match.isFromQueue() || !DuelManager.this.config.isEndCommandsQueueOnly())) {
                        try {
                            for (String command : DuelManager.this.config.getEndCommands()) {
                                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("%winner%", winner.getName()).replace("%loser%", player.getName()).replace("%kit%", kitName).replace("%arena%", arena.getName()).replace("%bet_amount%", String.valueOf(match.getBet())));
                            }
                        }
                        catch (Exception ex) {
                            Log.warn(DuelManager.this, "Error while running match end commands: " + ex.getMessage());
                        }
                    }
                    arena.endMatch(winner.getUniqueId(), player.getUniqueId(), MatchEndEvent.Reason.OPPONENT_DEFEAT);
                }, (long)DuelManager.this.config.getTeleportDelay() * 20L);
            }, 1L);
        }

        @EventHandler(ignoreCancelled=true)
        public void on(EntityDamageEvent event) {
            if (!(event.getEntity() instanceof Player)) {
                return;
            }
            Player player = (Player)event.getEntity();
            ArenaImpl arena = DuelManager.this.arenaManager.get(player);
            if (arena == null || !arena.isEndGame()) {
                return;
            }
            event.setCancelled(true);
        }

        @EventHandler
        public void on(PlayerQuitEvent event) {
            Player player = event.getPlayer();
            if (!DuelManager.this.arenaManager.isInMatch(player)) {
                return;
            }
            player.setHealth(0.0);
        }

        @EventHandler(ignoreCancelled=true)
        public void on(PlayerDropItemEvent event) {
            if (!DuelManager.this.config.isPreventItemDrop() || !DuelManager.this.arenaManager.isInMatch(event.getPlayer())) {
                return;
            }
            event.setCancelled(true);
            DuelManager.this.lang.sendMessage((CommandSender)event.getPlayer(), "DUEL.prevent.item-drop", new Object[0]);
        }

        @EventHandler(ignoreCancelled=true)
        public void on(PlayerPickupItemEvent event) {
            if (!CompatUtil.isPre1_13() && event.getItem().getItemStack().getType() == Material.TRIDENT) {
                return;
            }
            if (!DuelManager.this.config.isPreventItemPickup() || !DuelManager.this.arenaManager.isInMatch(event.getPlayer())) {
                return;
            }
            event.setCancelled(true);
        }

        @EventHandler(ignoreCancelled=true)
        public void on(PlayerCommandPreprocessEvent event) {
            String command = event.getMessage().substring(1).split(" ")[0].toLowerCase();
            if (!DuelManager.this.arenaManager.isInMatch(event.getPlayer()) || (DuelManager.this.config.isBlockAllCommands() ? DuelManager.this.config.getWhitelistedCommands().contains(command) : !DuelManager.this.config.getBlacklistedCommands().contains(command))) {
                return;
            }
            event.setCancelled(true);
            DuelManager.this.lang.sendMessage((CommandSender)event.getPlayer(), "DUEL.prevent.command", "command", event.getMessage());
        }

        @EventHandler(ignoreCancelled=true)
        public void on(PlayerTeleportEvent event) {
            Player player = event.getPlayer();
            Location to = event.getTo();
            if (!DuelManager.this.config.isLimitTeleportEnabled() || event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL || event.getCause() == PlayerTeleportEvent.TeleportCause.SPECTATE || !DuelManager.this.arenaManager.isInMatch(player)) {
                return;
            }
            Location from = event.getFrom();
            if (from.getWorld().equals(to.getWorld()) && from.distance(to) <= DuelManager.this.config.getDistanceAllowed()) {
                return;
            }
            event.setCancelled(true);
            DuelManager.this.lang.sendMessage((CommandSender)player, "DUEL.prevent.teleportation", new Object[0]);
        }

        @EventHandler(ignoreCancelled=true)
        public void on(InventoryOpenEvent event) {
            if (!DuelManager.this.config.isPreventInventoryOpen()) {
                return;
            }
            Player player = (Player)event.getPlayer();
            if (!DuelManager.this.arenaManager.isInMatch(player)) {
                return;
            }
            event.setCancelled(true);
            DuelManager.this.lang.sendMessage((CommandSender)player, "DUEL.prevent.inventory-open", new Object[0]);
        }
    }
}

