/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.data;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.realized.duels.api.kit.Kit;
import me.realized.duels.api.user.MatchInfo;
import me.realized.duels.api.user.User;
import me.realized.duels.data.MatchData;
import me.realized.duels.util.Log;
import me.realized.duels.util.json.JsonUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class UserData
implements User {
    private static final transient String ERROR_USER_SAVE = "An error occured while saving userdata of %s!";
    private UUID uuid;
    private String name;
    private volatile int wins;
    private volatile int losses;
    private boolean requests = true;
    private ConcurrentHashMap<String, Integer> rating;
    private List<MatchData> matches = new ArrayList<MatchData>();
    transient File folder;
    transient int defaultRating;
    transient int matchesToDisplay;

    private UserData() {
    }

    public UserData(File folder, int defaultRating, int matchesToDisplay, Player player) {
        this.folder = folder;
        this.defaultRating = defaultRating;
        this.matchesToDisplay = matchesToDisplay;
        this.uuid = player.getUniqueId();
        this.name = player.getName();
    }

    @Override
    public void setWins(int wins) {
        this.wins = wins;
        if (!this.isOnline()) {
            this.trySave();
        }
    }

    @Override
    public void setLosses(int losses) {
        this.losses = losses;
        if (!this.isOnline()) {
            this.trySave();
        }
    }

    @Override
    public boolean canRequest() {
        return this.requests;
    }

    @Override
    public void setRequests(boolean requests) {
        this.requests = requests;
        if (!this.isOnline()) {
            this.trySave();
        }
    }

    @Override
    @NotNull
    public List<MatchInfo> getMatches() {
        return Collections.unmodifiableList(this.matches);
    }

    @Override
    public int getRating() {
        return this.getRatingUnsafe(null);
    }

    @Override
    public int getRating(@NotNull Kit kit) {
        return this.getRatingUnsafe(kit);
    }

    @Override
    public void resetRating() {
        this.setRating(null, this.defaultRating);
    }

    @Override
    public void resetRating(@NotNull Kit kit) {
        this.setRating(kit, this.defaultRating);
    }

    @Override
    public void reset() {
        this.wins = 0;
        this.losses = 0;
        this.matches.clear();
        this.rating.clear();
        if (!this.isOnline()) {
            this.trySave();
        }
    }

    private int getRatingUnsafe(Kit kit) {
        return this.rating != null ? this.rating.getOrDefault(kit == null ? "-" : kit.getName(), this.defaultRating) : this.defaultRating;
    }

    public void setRating(Kit kit, int rating) {
        if (this.rating == null) {
            this.rating = new ConcurrentHashMap();
        }
        this.rating.put(kit == null ? "-" : kit.getName(), rating);
        if (!this.isOnline()) {
            this.trySave();
        }
    }

    private boolean isOnline() {
        return Bukkit.getPlayer((UUID)this.uuid) != null;
    }

    public void addWin() {
        int wins = this.wins;
        this.wins = wins + 1;
    }

    public void addLoss() {
        int losses = this.losses;
        this.losses = losses + 1;
    }

    public void addMatch(MatchData matchData) {
        if (!this.matches.isEmpty() && this.matches.size() >= this.matchesToDisplay) {
            this.matches.remove(0);
        }
        this.matches.add(matchData);
    }

    void refreshMatches() {
        if (this.matches.size() < this.matchesToDisplay) {
            return;
        }
        ArrayList division = Lists.newArrayList(this.matches.subList(this.matches.size() - this.matchesToDisplay, this.matches.size()));
        this.matches.clear();
        this.matches.addAll(division);
    }

    public void trySave() {
        File file = new File(this.folder, this.uuid + ".json");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);){
                JsonUtil.getObjectWriter().writeValue(writer, (Object)this);
                ((Writer)writer).flush();
            }
        }
        catch (IOException ex) {
            Log.error(String.format(ERROR_USER_SAVE, this.name), ex);
        }
    }

    public String toString() {
        return "UserData{uuid=" + this.uuid + ", name='" + this.name + '\'' + ", wins=" + this.wins + ", losses=" + this.losses + ", requests=" + this.requests + ", matches=" + this.matches + ", rating=" + this.rating + '}';
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getWins() {
        return this.wins;
    }

    @Override
    public int getLosses() {
        return this.losses;
    }
}

