/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.data.ItemData;
import me.realized.duels.kit.KitImpl;
import me.realized.duels.util.Log;
import me.realized.duels.util.inventory.ItemBuilder;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class KitData {
    private static final transient String SLOT_LOAD_FAILURE = "Could not load slot %s for kit %s!";
    private static final transient String ITEM_LOAD_FAILURE = "Could not load item %s for kit %s!";
    private String name;
    private ItemData displayed;
    private boolean usePermission;
    private boolean arenaSpecific;
    private Set<KitImpl.Characteristic> characteristics = new HashSet<KitImpl.Characteristic>();
    private Map<String, Map<Integer, ItemData>> items = new HashMap<String, Map<Integer, ItemData>>();

    public static KitData fromKit(KitImpl kit) {
        return new KitData(kit);
    }

    private KitData() {
    }

    private KitData(KitImpl kit) {
        this.name = kit.getName();
        this.displayed = ItemData.fromItemStack(kit.getDisplayed());
        this.usePermission = kit.isUsePermission();
        this.arenaSpecific = kit.isArenaSpecific();
        this.characteristics.addAll(kit.getCharacteristics());
        for (Map.Entry<String, Map<Integer, ItemStack>> entry : kit.getItems().entrySet()) {
            HashMap data = new HashMap();
            entry.getValue().entrySet().stream().filter(value -> Objects.nonNull(value.getValue())).forEach(value -> data.put(value.getKey(), ItemData.fromItemStack((ItemStack)value.getValue())));
            this.items.put(entry.getKey(), data);
        }
    }

    public KitImpl toKit(DuelsPlugin plugin) {
        ItemStack displayed;
        if (this.displayed == null || (displayed = this.displayed.toItemStack()) == null) {
            displayed = ItemBuilder.of(Material.BARRIER).name("&cCould not load displayed item for " + this.name + "!").build();
        }
        KitImpl kit = new KitImpl(plugin, this.name, displayed, this.usePermission, this.arenaSpecific, this.characteristics);
        for (Map.Entry<String, Map<Integer, ItemData>> entry : this.items.entrySet()) {
            HashMap data = new HashMap();
            entry.getValue().forEach((slot, itemData) -> {
                if (itemData == null) {
                    Log.warn(String.format(SLOT_LOAD_FAILURE, slot, kit.getName()));
                    return;
                }
                ItemStack item = itemData.toItemStack();
                if (item == null) {
                    Log.warn(String.format(ITEM_LOAD_FAILURE, itemData, kit.getName()));
                    return;
                }
                data.put(slot, item);
            });
            kit.getItems().put(entry.getKey(), data);
        }
        return kit;
    }
}

