/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.arena.ArenaImpl;
import me.realized.duels.data.LocationData;
import me.realized.duels.kit.KitImpl;
import org.bukkit.Location;

public class ArenaData {
    private String name;
    private boolean disabled;
    private Set<String> kits = new HashSet<String>();
    private Map<Integer, LocationData> positions = new HashMap<Integer, LocationData>();

    private ArenaData() {
    }

    public ArenaData(ArenaImpl arena) {
        this.name = arena.getName();
        this.disabled = arena.isDisabled();
        arena.getKits().forEach(kit -> this.kits.add(kit.getName()));
        arena.getPositions().entrySet().stream().filter(entry -> ((Location)entry.getValue()).getWorld() != null).forEach(entry -> this.positions.put((Integer)entry.getKey(), LocationData.fromLocation((Location)entry.getValue())));
    }

    public ArenaImpl toArena(DuelsPlugin plugin) {
        ArenaImpl arena = new ArenaImpl(plugin, this.name, this.disabled);
        this.kits.stream().map(name -> plugin.getKitManager().get((String)name)).filter(Objects::nonNull).forEach(kit -> arena.getKits().add((KitImpl)kit));
        this.positions.forEach((key, value) -> arena.getPositions().put((Integer)key, value.toLocation()));
        arena.refreshGui(arena.isAvailable());
        return arena;
    }

    public String getName() {
        return this.name;
    }
}

