/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.config;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.config.Config;
import me.realized.duels.util.Log;
import me.realized.duels.util.Reloadable;
import me.realized.duels.util.StringUtil;
import me.realized.duels.util.config.AbstractConfiguration;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class Lang
extends AbstractConfiguration<DuelsPlugin>
implements Reloadable {
    private final Config config;
    private final Map<String, String> messages = new HashMap<String, String>();

    public Lang(DuelsPlugin plugin) {
        super(plugin, "lang");
        this.config = plugin.getConfiguration();
    }

    @Override
    protected void loadValues(FileConfiguration configuration) throws Exception {
        if (configuration.getInt("config-version", 0) < this.getLatestVersion()) {
            configuration = this.convert(null);
        }
        HashMap<String, String> strings = new HashMap<String, String>();
        for (String key2 : configuration.getKeys(true)) {
            String message;
            Object value2;
            if (key2.equals("config-version")) continue;
            if (key2.startsWith(".")) {
                key2 = key2.substring(1);
            }
            if ((value2 = configuration.get(key2)) == null || value2 instanceof MemorySection) continue;
            String string = message = value2 instanceof List ? StringUtil.fromList((List)value2) : value2.toString();
            if (key2.startsWith("STRINGS")) {
                String[] args = key2.split(Pattern.quote("."));
                strings.put(args[args.length - 1], message);
                continue;
            }
            this.messages.put(key2, message);
        }
        this.messages.replaceAll((key, value) -> {
            for (Map.Entry entry : strings.entrySet()) {
                String placeholder = "{" + (String)entry.getKey() + "}";
                if (!StringUtil.containsIgnoreCase(value, placeholder)) continue;
                value = value.replaceAll("(?i)" + Pattern.quote(placeholder), (String)entry.getValue());
            }
            return value;
        });
    }

    @Override
    protected Set<String> transferredSections() {
        return Sets.newHashSet((Object[])new String[]{"STRINGS"});
    }

    @Override
    public void handleUnload() {
        this.messages.clear();
    }

    private String getRawMessage(String key) {
        String message = this.messages.get(key);
        if (message == null) {
            Log.error(this, "Failed to load message: provided key '" + key + "' has no assigned value");
            return null;
        }
        return !message.isEmpty() ? message : null;
    }

    public String getMessage(String key) {
        String message = this.getRawMessage(key);
        return message != null ? StringUtil.color(message) : null;
    }

    private String replace(String message, Object ... replacers) {
        if (replacers.length == 1 && replacers[0] instanceof Object[]) {
            replacers = (Object[])replacers[0];
        }
        for (int i = 0; i < replacers.length && i + 1 < replacers.length; i += 2) {
            message = message.replace("%" + replacers[i].toString() + "%", String.valueOf(replacers[i + 1]));
        }
        return message;
    }

    public String getMessage(String key, Object ... replacers) {
        String message = this.getMessage(key);
        return message != null ? this.replace(message, replacers) : null;
    }

    public void sendMessage(CommandSender receiver, String key, Object ... replacers) {
        String message = this.getRawMessage(key);
        if (message == null) {
            return;
        }
        if (receiver instanceof Player) {
            this.config.playSound((Player)receiver, message);
        }
        receiver.sendMessage(StringUtil.color(this.replace(message, replacers)));
    }

    public void sendMessage(Collection<Player> players, String key, Object ... replacers) {
        players.forEach(player -> this.sendMessage((CommandSender)player, key, replacers));
    }
}

