/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.config.converters.ConfigConverter9_10;
import me.realized.duels.util.EnumUtil;
import me.realized.duels.util.config.AbstractConfiguration;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class Config
extends AbstractConfiguration<DuelsPlugin> {
    private int version;
    private boolean checkForUpdates;
    private boolean ctpPreventDuel;
    private boolean ctpPreventTag;
    private boolean pmPreventDuel;
    private boolean pmPreventTag;
    private boolean clxPreventDuel;
    private boolean clxPreventTag;
    private boolean autoUnvanish;
    private boolean setBackLocation;
    private boolean disableSkills;
    private boolean fuNoPowerLoss;
    private boolean fNoPowerLoss;
    private boolean duelzoneEnabled;
    private List<String> duelzones;
    private boolean myPetDespawn;
    private boolean preventBountyLoss;
    private boolean preventKDRChange;
    private String lhWinsCmd;
    private String lhWinsTitle;
    private String lhLossesCmd;
    private String lhLossesTitle;
    private boolean requiresClearedInventory;
    private boolean preventCreativeMode;
    private boolean ownInventoryEnabled;
    private boolean ownInventoryUsePermission;
    private boolean kitSelectingEnabled;
    private boolean kitSelectingUsePermission;
    private boolean arenaSelectingEnabled;
    private boolean arenaSelectingUsePermission;
    private boolean itemBettingEnabled;
    private boolean itemBettingUsePermission;
    private boolean moneyBettingEnabled;
    private boolean moneyBettingUsePermission;
    private int expiration;
    private int maxDuration;
    private boolean startCommandsEnabled;
    private boolean startCommandsQueueOnly;
    private List<String> startCommands;
    private boolean endCommandsEnabled;
    private boolean endCommandsQueueOnly;
    private List<String> endCommands;
    private boolean projectileHitMessageEnabled;
    private List<String> projectileHitMessageTypes;
    private boolean preventInventoryOpen;
    private boolean protectKitItems;
    private boolean removeEmptyBottle;
    private boolean preventTpToMatchPlayers;
    private boolean forceAllowCombat;
    private boolean cancelIfMoved;
    private List<String> blacklistedWorlds;
    private boolean teleportToLastLocation;
    private int teleportDelay;
    private boolean spawnFirework;
    private boolean arenaOnlyEndMessage;
    private boolean displayInventories;
    private boolean preventItemDrop;
    private boolean preventItemPickup;
    private boolean limitTeleportEnabled;
    private double distanceAllowed;
    private boolean blockAllCommands;
    private List<String> whitelistedCommands;
    private List<String> blacklistedCommands;
    private List<String> queueBlacklistedCommands;
    private boolean ratingEnabled;
    private int kFactor;
    private int defaultRating;
    private boolean ratingQueueOnly;
    private boolean specRequiresClearedInventory;
    private boolean specUseSpectatorGamemode;
    private boolean specAddInvisibilityEffect;
    private List<String> specWhitelistedCommands;
    private boolean cdEnabled;
    private List<String> cdMessages;
    private List<String> titles;
    private boolean preventMovement;
    private boolean preventLaunchProjectile;
    private boolean preventPvp;
    private boolean preventInteract;
    private boolean displayKitRatings;
    private boolean displayNoKitRating;
    private boolean displayPastMatches;
    private int matchesToDisplay;
    private long topUpdateInterval;
    private String topWinsType;
    private String topWinsIdentifier;
    private String topLossesType;
    private String topLossesIdentifier;
    private String topKitType;
    private String topKitIdentifier;
    private String topNoKitType;
    private String topNoKitIdentifier;
    private int kitSelectorRows;
    private String kitSelectorFillerType;
    private short kitSelectorFillerData;
    private int arenaSelectorRows;
    private String arenaSelectorFillerType;
    private short arenaSelectorFillerData;
    private String settingsFillerType;
    private short settingsFillerData;
    private int queuesRows;
    private String queuesFillerType;
    private short queuesFillerData;
    private boolean inheritKitItemType;
    private double soupHeartsToRegen;
    private boolean soupRemoveEmptyBowl;
    private boolean soupCancelIfAlreadyFull;
    private final Map<String, MessageSound> sounds = new HashMap<String, MessageSound>();

    public Config(DuelsPlugin plugin) {
        super(plugin, "config");
    }

    @Override
    protected void loadValues(FileConfiguration configuration) throws Exception {
        int prevVersion = configuration.getInt("config-version", 0);
        if (prevVersion < 10) {
            configuration = this.convert(new ConfigConverter9_10());
        } else if (prevVersion < this.getLatestVersion()) {
            configuration = this.convert(null);
        }
        this.version = configuration.getInt("config-version");
        this.checkForUpdates = configuration.getBoolean("check-for-updates", true);
        this.ctpPreventDuel = configuration.getBoolean("supported-plugins.CombatTagPlus.prevent-duel-if-tagged", true);
        this.ctpPreventTag = configuration.getBoolean("supported-plugins.CombatTagPlus.prevent-tag-in-duel", true);
        this.pmPreventDuel = configuration.getBoolean("supported-plugins.PvPManager.prevent-duel-if-tagged", true);
        this.pmPreventTag = configuration.getBoolean("supported-plugins.PvPManager.prevent-tag-in-duel", true);
        this.clxPreventDuel = configuration.getBoolean("supported-plugins.CombatLogX.prevent-duel-if-tagged", true);
        this.clxPreventTag = configuration.getBoolean("supported-plugins.CombatLogX.prevent-tag-in-duel", true);
        this.autoUnvanish = configuration.getBoolean("supported-plugins.Essentials.auto-unvanish", true);
        this.setBackLocation = configuration.getBoolean("supported-plugins.Essentials.set-back-location", true);
        this.disableSkills = configuration.getBoolean("supported-plugins.mcMMO.disable-skills-in-duel", true);
        this.fuNoPowerLoss = configuration.getBoolean("supported-plugins.FactionsUUID.no-power-loss-in-duel", true);
        this.fNoPowerLoss = configuration.getBoolean("supported-plugins.Factions.no-power-loss-in-duel", true);
        this.duelzoneEnabled = configuration.getBoolean("supported-plugins.WorldGuard.duelzone.enabled", false);
        this.duelzones = configuration.getStringList("supported-plugins.WorldGuard.duelzone.regions");
        this.myPetDespawn = configuration.getBoolean("supported-plugins.MyPet.despawn-pet-in-duel", false);
        this.preventBountyLoss = configuration.getBoolean("supported-plugins.BountyHunters.prevent-bounty-loss-in-duel", true);
        this.preventKDRChange = configuration.getBoolean("supported-plugins.SimpleClans.prevent-kdr-change", true);
        this.lhWinsCmd = configuration.getString("supported-plugins.LeaderHeads.wins.menu.command", "openwins");
        this.lhWinsTitle = configuration.getString("supported-plugins.LeaderHeads.wins.menu.title", "Duel Wins");
        this.lhLossesCmd = configuration.getString("supported-plugins.LeaderHeads.losses.menu.command", "openlosses");
        this.lhLossesTitle = configuration.getString("supported-plugins.LeaderHeads.losses.menu.title", "Duel Losses");
        this.requiresClearedInventory = configuration.getBoolean("request.requires-cleared-inventory", true);
        this.preventCreativeMode = configuration.getBoolean("request.prevent-creative-mode", false);
        this.ownInventoryEnabled = configuration.getBoolean("request.use-own-inventory.enabled", true);
        this.ownInventoryUsePermission = configuration.getBoolean("request.use-own-inventory.use-permission", false);
        this.kitSelectingEnabled = configuration.getBoolean("request.kit-selecting.enabled", true);
        this.kitSelectingUsePermission = configuration.getBoolean("request.kit-selecting.use-permission", false);
        this.arenaSelectingEnabled = configuration.getBoolean("request.arena-selecting.enabled", true);
        this.arenaSelectingUsePermission = configuration.getBoolean("request.arena-selecting.use-permission", false);
        this.itemBettingEnabled = configuration.getBoolean("request.item-betting.enabled", true);
        this.itemBettingUsePermission = configuration.getBoolean("request.item-betting.use-permission", false);
        this.moneyBettingEnabled = configuration.getBoolean("request.money-betting.enabled", true);
        this.moneyBettingUsePermission = configuration.getBoolean("request.money-betting.use-permission", false);
        this.expiration = Math.max(configuration.getInt("request.expiration", 30), 0);
        this.maxDuration = configuration.getInt("duel.match.max-duration", -1);
        this.startCommandsEnabled = configuration.getBoolean("duel.match.start-commands.enabled", false);
        this.startCommandsQueueOnly = configuration.getBoolean("duel.match.start-commands.queue-matches-only", false);
        this.startCommands = configuration.getStringList("duel.match.start-commands.commands");
        this.endCommandsEnabled = configuration.getBoolean("duel.match.end-commands.enabled", false);
        this.endCommandsQueueOnly = configuration.getBoolean("duel.match.end-commands.queue-matches-only", false);
        this.endCommands = configuration.getStringList("duel.match.end-commands.commands");
        this.projectileHitMessageEnabled = configuration.getBoolean("duel.projectile-hit-message.enabled", true);
        this.projectileHitMessageTypes = configuration.getStringList("duel.projectile-hit-message.types");
        this.preventInventoryOpen = configuration.getBoolean("duel.prevent-inventory-open", true);
        this.protectKitItems = configuration.getBoolean("duel.protect-kit-items", true);
        this.removeEmptyBottle = configuration.getBoolean("duel.remove-empty-bottle", true);
        this.preventTpToMatchPlayers = configuration.getBoolean("duel.prevent-teleport-to-match-players", true);
        this.forceAllowCombat = configuration.getBoolean("duel.force-allow-combat", true);
        this.cancelIfMoved = configuration.getBoolean("duel.cancel-if-moved", false);
        this.blacklistedWorlds = configuration.getStringList("duel.blacklisted-worlds");
        this.teleportToLastLocation = configuration.getBoolean("duel.teleport-to-last-location", false);
        this.teleportDelay = configuration.getInt("duel.teleport-delay", 5);
        this.spawnFirework = configuration.getBoolean("duel.spawn-firework", true);
        this.arenaOnlyEndMessage = configuration.getBoolean("duel.arena-only-end-message", false);
        this.displayInventories = configuration.getBoolean("duel.display-inventories", true);
        this.preventItemDrop = configuration.getBoolean("duel.prevent-item-drop", false);
        this.preventItemPickup = configuration.getBoolean("duel.prevent-item-pickup", true);
        this.limitTeleportEnabled = configuration.getBoolean("duel.limit-teleportation.enabled", true);
        this.distanceAllowed = configuration.getDouble("duel.limit-teleportation.distance-allowed", 5.0);
        this.blockAllCommands = configuration.getBoolean("duel.block-all-commands", false);
        this.whitelistedCommands = configuration.getStringList("duel.whitelisted-commands");
        this.blacklistedCommands = configuration.getStringList("duel.blacklisted-commands");
        this.queueBlacklistedCommands = configuration.getStringList("queue.blacklisted-commands");
        this.ratingEnabled = configuration.getBoolean("rating.enabled", true);
        this.kFactor = Math.max(configuration.getInt("rating.k-factor", 32), 1);
        this.defaultRating = Math.max(configuration.getInt("rating.default-rating", 1400), 0);
        this.ratingQueueOnly = configuration.getBoolean("rating.queue-matches-only", true);
        this.specRequiresClearedInventory = configuration.getBoolean("spectate.requires-cleared-inventory", false);
        this.specUseSpectatorGamemode = configuration.getBoolean("spectate.use-spectator-gamemode", false);
        this.specAddInvisibilityEffect = configuration.getBoolean("spectate.add-invisibility-effect", true);
        this.specWhitelistedCommands = configuration.getStringList("spectate.whitelisted-commands");
        this.cdEnabled = configuration.getBoolean("countdown.enabled", true);
        this.cdMessages = configuration.getStringList("countdown.messages");
        this.titles = configuration.getStringList("countdown.titles");
        this.preventMovement = configuration.getBoolean("countdown.prevent.movement", true);
        this.preventLaunchProjectile = configuration.getBoolean("countdown.prevent.launch-projectile", true);
        this.preventPvp = configuration.getBoolean("countdown.prevent.pvp", true);
        this.preventInteract = configuration.getBoolean("countdown.prevent.interact", true);
        this.displayKitRatings = configuration.getBoolean("stats.display-kit-ratings", true);
        this.displayNoKitRating = configuration.getBoolean("stats.display-nokit-rating", false);
        this.displayPastMatches = configuration.getBoolean("stats.display-past-matches", true);
        this.matchesToDisplay = Math.max(configuration.getInt("stats.matches-to-display", 10), 0);
        this.topUpdateInterval = (long)Math.max(configuration.getInt("top.update-interval", 5), 1) * 60L * 1000L;
        this.topWinsType = configuration.getString("top.displayed-replacers.wins.type", "Wins");
        this.topWinsIdentifier = configuration.getString("top.displayed-replacers.wins.identifier", "wins");
        this.topLossesType = configuration.getString("top.displayed-replacers.losses.type", "Losses");
        this.topLossesIdentifier = configuration.getString("top.displayed-replacers.losses.identifier", "losses");
        this.topKitType = configuration.getString("top.displayed-replacers.kit.type", "%kit%");
        this.topKitIdentifier = configuration.getString("top.displayed-replacers.kit.identifier", "rating");
        this.topNoKitType = configuration.getString("top.displayed-replacers.no-kit.type", "No Kit");
        this.topNoKitIdentifier = configuration.getString("top.displayed-replacers.no-kit.identifier", "rating");
        this.kitSelectorRows = Math.min(Math.max(configuration.getInt("guis.kit-selector.rows", 2), 1), 5);
        this.kitSelectorFillerType = configuration.getString("guis.kit-selector.space-filler-item.type", "STAINED_GLASS_PANE");
        this.kitSelectorFillerData = (short)configuration.getInt("guis.kit-selector.space-filler-item.data", 0);
        this.arenaSelectorRows = Math.min(Math.max(configuration.getInt("guis.arena-selector.rows", 3), 1), 5);
        this.arenaSelectorFillerType = configuration.getString("guis.arena-selector.space-filler-item.type", "STAINED_GLASS_PANE");
        this.arenaSelectorFillerData = (short)configuration.getInt("guis.arena-selector.space-filler-item.data", 0);
        this.settingsFillerType = configuration.getString("guis.settings.space-filler-item.type", "STAINED_GLASS_PANE");
        this.settingsFillerData = (short)configuration.getInt("guis.settings.space-filler-item.data", 0);
        this.queuesRows = Math.min(Math.max(configuration.getInt("guis.queues.rows", 3), 1), 5);
        this.queuesFillerType = configuration.getString("guis.queues.space-filler-item.type", "STAINED_GLASS_PANE");
        this.queuesFillerData = (short)configuration.getInt("guis.queues.space-filler-item.data", 0);
        this.inheritKitItemType = configuration.getBoolean("guis.queues.inherit-kit-item-type", true);
        this.soupHeartsToRegen = Math.max(configuration.getDouble("soup.hearts-to-regen", 3.5), 0.0);
        this.soupRemoveEmptyBowl = configuration.getBoolean("soup.remove-empty-bowl", true);
        this.soupCancelIfAlreadyFull = configuration.getBoolean("soup.cancel-if-already-full", true);
        ConfigurationSection sounds = configuration.getConfigurationSection("sounds");
        if (sounds != null) {
            for (String name : sounds.getKeys(false)) {
                ConfigurationSection sound = sounds.getConfigurationSection(name);
                Sound type = EnumUtil.getByName(sound.getString("type"), Sound.class);
                if (type == null) continue;
                this.sounds.put(name, new MessageSound(type, sound.getDouble("pitch"), sound.getDouble("volume"), sound.getStringList("trigger-messages")));
            }
        }
    }

    public void playSound(Player player, String message) {
        this.sounds.values().stream().filter(sound -> sound.getMessages().contains(message)).forEach(sound -> player.playSound(player.getLocation(), sound.getType(), sound.getVolume(), sound.getPitch()));
    }

    public MessageSound getSound(String name) {
        return this.sounds.get(name);
    }

    public Set<String> getSounds() {
        return this.sounds.keySet();
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isCheckForUpdates() {
        return this.checkForUpdates;
    }

    public boolean isCtpPreventDuel() {
        return this.ctpPreventDuel;
    }

    public boolean isCtpPreventTag() {
        return this.ctpPreventTag;
    }

    public boolean isPmPreventDuel() {
        return this.pmPreventDuel;
    }

    public boolean isPmPreventTag() {
        return this.pmPreventTag;
    }

    public boolean isClxPreventDuel() {
        return this.clxPreventDuel;
    }

    public boolean isClxPreventTag() {
        return this.clxPreventTag;
    }

    public boolean isAutoUnvanish() {
        return this.autoUnvanish;
    }

    public boolean isSetBackLocation() {
        return this.setBackLocation;
    }

    public boolean isDisableSkills() {
        return this.disableSkills;
    }

    public boolean isFuNoPowerLoss() {
        return this.fuNoPowerLoss;
    }

    public boolean isFNoPowerLoss() {
        return this.fNoPowerLoss;
    }

    public boolean isDuelzoneEnabled() {
        return this.duelzoneEnabled;
    }

    public List<String> getDuelzones() {
        return this.duelzones;
    }

    public boolean isMyPetDespawn() {
        return this.myPetDespawn;
    }

    public boolean isPreventBountyLoss() {
        return this.preventBountyLoss;
    }

    public boolean isPreventKDRChange() {
        return this.preventKDRChange;
    }

    public String getLhWinsCmd() {
        return this.lhWinsCmd;
    }

    public String getLhWinsTitle() {
        return this.lhWinsTitle;
    }

    public String getLhLossesCmd() {
        return this.lhLossesCmd;
    }

    public String getLhLossesTitle() {
        return this.lhLossesTitle;
    }

    public boolean isRequiresClearedInventory() {
        return this.requiresClearedInventory;
    }

    public boolean isPreventCreativeMode() {
        return this.preventCreativeMode;
    }

    public boolean isOwnInventoryEnabled() {
        return this.ownInventoryEnabled;
    }

    public boolean isOwnInventoryUsePermission() {
        return this.ownInventoryUsePermission;
    }

    public boolean isKitSelectingEnabled() {
        return this.kitSelectingEnabled;
    }

    public boolean isKitSelectingUsePermission() {
        return this.kitSelectingUsePermission;
    }

    public boolean isArenaSelectingEnabled() {
        return this.arenaSelectingEnabled;
    }

    public boolean isArenaSelectingUsePermission() {
        return this.arenaSelectingUsePermission;
    }

    public boolean isItemBettingEnabled() {
        return this.itemBettingEnabled;
    }

    public boolean isItemBettingUsePermission() {
        return this.itemBettingUsePermission;
    }

    public boolean isMoneyBettingEnabled() {
        return this.moneyBettingEnabled;
    }

    public boolean isMoneyBettingUsePermission() {
        return this.moneyBettingUsePermission;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public boolean isStartCommandsEnabled() {
        return this.startCommandsEnabled;
    }

    public boolean isStartCommandsQueueOnly() {
        return this.startCommandsQueueOnly;
    }

    public List<String> getStartCommands() {
        return this.startCommands;
    }

    public boolean isEndCommandsEnabled() {
        return this.endCommandsEnabled;
    }

    public boolean isEndCommandsQueueOnly() {
        return this.endCommandsQueueOnly;
    }

    public List<String> getEndCommands() {
        return this.endCommands;
    }

    public boolean isProjectileHitMessageEnabled() {
        return this.projectileHitMessageEnabled;
    }

    public List<String> getProjectileHitMessageTypes() {
        return this.projectileHitMessageTypes;
    }

    public boolean isPreventInventoryOpen() {
        return this.preventInventoryOpen;
    }

    public boolean isProtectKitItems() {
        return this.protectKitItems;
    }

    public boolean isRemoveEmptyBottle() {
        return this.removeEmptyBottle;
    }

    public boolean isPreventTpToMatchPlayers() {
        return this.preventTpToMatchPlayers;
    }

    public boolean isForceAllowCombat() {
        return this.forceAllowCombat;
    }

    public boolean isCancelIfMoved() {
        return this.cancelIfMoved;
    }

    public List<String> getBlacklistedWorlds() {
        return this.blacklistedWorlds;
    }

    public boolean isTeleportToLastLocation() {
        return this.teleportToLastLocation;
    }

    public int getTeleportDelay() {
        return this.teleportDelay;
    }

    public boolean isSpawnFirework() {
        return this.spawnFirework;
    }

    public boolean isArenaOnlyEndMessage() {
        return this.arenaOnlyEndMessage;
    }

    public boolean isDisplayInventories() {
        return this.displayInventories;
    }

    public boolean isPreventItemDrop() {
        return this.preventItemDrop;
    }

    public boolean isPreventItemPickup() {
        return this.preventItemPickup;
    }

    public boolean isLimitTeleportEnabled() {
        return this.limitTeleportEnabled;
    }

    public double getDistanceAllowed() {
        return this.distanceAllowed;
    }

    public boolean isBlockAllCommands() {
        return this.blockAllCommands;
    }

    public List<String> getWhitelistedCommands() {
        return this.whitelistedCommands;
    }

    public List<String> getBlacklistedCommands() {
        return this.blacklistedCommands;
    }

    public List<String> getQueueBlacklistedCommands() {
        return this.queueBlacklistedCommands;
    }

    public boolean isRatingEnabled() {
        return this.ratingEnabled;
    }

    public int getKFactor() {
        return this.kFactor;
    }

    public int getDefaultRating() {
        return this.defaultRating;
    }

    public boolean isRatingQueueOnly() {
        return this.ratingQueueOnly;
    }

    public boolean isSpecRequiresClearedInventory() {
        return this.specRequiresClearedInventory;
    }

    public boolean isSpecUseSpectatorGamemode() {
        return this.specUseSpectatorGamemode;
    }

    public boolean isSpecAddInvisibilityEffect() {
        return this.specAddInvisibilityEffect;
    }

    public List<String> getSpecWhitelistedCommands() {
        return this.specWhitelistedCommands;
    }

    public boolean isCdEnabled() {
        return this.cdEnabled;
    }

    public List<String> getCdMessages() {
        return this.cdMessages;
    }

    public List<String> getTitles() {
        return this.titles;
    }

    public boolean isPreventMovement() {
        return this.preventMovement;
    }

    public boolean isPreventLaunchProjectile() {
        return this.preventLaunchProjectile;
    }

    public boolean isPreventPvp() {
        return this.preventPvp;
    }

    public boolean isPreventInteract() {
        return this.preventInteract;
    }

    public boolean isDisplayKitRatings() {
        return this.displayKitRatings;
    }

    public boolean isDisplayNoKitRating() {
        return this.displayNoKitRating;
    }

    public boolean isDisplayPastMatches() {
        return this.displayPastMatches;
    }

    public int getMatchesToDisplay() {
        return this.matchesToDisplay;
    }

    public long getTopUpdateInterval() {
        return this.topUpdateInterval;
    }

    public String getTopWinsType() {
        return this.topWinsType;
    }

    public String getTopWinsIdentifier() {
        return this.topWinsIdentifier;
    }

    public String getTopLossesType() {
        return this.topLossesType;
    }

    public String getTopLossesIdentifier() {
        return this.topLossesIdentifier;
    }

    public String getTopKitType() {
        return this.topKitType;
    }

    public String getTopKitIdentifier() {
        return this.topKitIdentifier;
    }

    public String getTopNoKitType() {
        return this.topNoKitType;
    }

    public String getTopNoKitIdentifier() {
        return this.topNoKitIdentifier;
    }

    public int getKitSelectorRows() {
        return this.kitSelectorRows;
    }

    public String getKitSelectorFillerType() {
        return this.kitSelectorFillerType;
    }

    public short getKitSelectorFillerData() {
        return this.kitSelectorFillerData;
    }

    public int getArenaSelectorRows() {
        return this.arenaSelectorRows;
    }

    public String getArenaSelectorFillerType() {
        return this.arenaSelectorFillerType;
    }

    public short getArenaSelectorFillerData() {
        return this.arenaSelectorFillerData;
    }

    public String getSettingsFillerType() {
        return this.settingsFillerType;
    }

    public short getSettingsFillerData() {
        return this.settingsFillerData;
    }

    public int getQueuesRows() {
        return this.queuesRows;
    }

    public String getQueuesFillerType() {
        return this.queuesFillerType;
    }

    public short getQueuesFillerData() {
        return this.queuesFillerData;
    }

    public boolean isInheritKitItemType() {
        return this.inheritKitItemType;
    }

    public double getSoupHeartsToRegen() {
        return this.soupHeartsToRegen;
    }

    public boolean isSoupRemoveEmptyBowl() {
        return this.soupRemoveEmptyBowl;
    }

    public boolean isSoupCancelIfAlreadyFull() {
        return this.soupCancelIfAlreadyFull;
    }

    public class MessageSound {
        private final Sound type;
        private final float pitch;
        private final float volume;
        private final List<String> messages;

        MessageSound(Sound type, double pitch, double volume, List<String> messages) {
            this.type = type;
            this.pitch = (float)pitch;
            this.volume = (float)volume;
            this.messages = messages;
        }

        public Sound getType() {
            return this.type;
        }

        public float getPitch() {
            return this.pitch;
        }

        public float getVolume() {
            return this.volume;
        }

        public List<String> getMessages() {
            return this.messages;
        }
    }
}

