/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.command.commands.duels.subcommands;

import java.util.Arrays;
import java.util.List;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.arena.ArenaImpl;
import me.realized.duels.command.BaseCommand;
import me.realized.duels.util.NumberUtil;
import me.realized.duels.util.StringUtil;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetCommand
extends BaseCommand {
    public SetCommand(DuelsPlugin plugin) {
        super(plugin, "set", "set [name] [1:2]", "Sets the teleport position of an arena.", 3, true, new String[0]);
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
        String name = StringUtil.join(args, " ", 1, args.length - 1).replace("-", " ");
        ArenaImpl arena = this.arenaManager.get(name);
        if (arena == null) {
            this.lang.sendMessage(sender, "ERROR.arena.not-found", "name", name);
            return;
        }
        int pos = NumberUtil.parseInt(args[args.length - 1]).orElse(arena.getPositions().size() + 1);
        if (pos <= 0 || pos > 2) {
            this.lang.sendMessage(sender, "ERROR.arena.invalid-position", new Object[0]);
            return;
        }
        Player player = (Player)sender;
        Location location = player.getLocation().clone();
        arena.setPosition(player, pos, location);
        this.lang.sendMessage(sender, "COMMAND.duels.set", "position", pos, "name", name, "location", StringUtil.parse(location));
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 2) {
            return this.handleTabCompletion(args[1], this.arenaManager.getNames());
        }
        if (args.length > 2) {
            return Arrays.asList("1", "2");
        }
        return null;
    }
}

