/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.command.commands.duels.subcommands;

import java.util.List;
import java.util.stream.Collectors;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.arena.ArenaImpl;
import me.realized.duels.command.BaseCommand;
import me.realized.duels.kit.KitImpl;
import me.realized.duels.util.StringUtil;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class InfoCommand
extends BaseCommand {
    public InfoCommand(DuelsPlugin plugin) {
        super(plugin, "info", "info [name]", "Displays information about the selected arena.", 2, false, new String[0]);
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
        String name = StringUtil.join(args, " ", 1, args.length).replace("-", " ");
        ArenaImpl arena = this.arenaManager.get(name);
        if (arena == null) {
            this.lang.sendMessage(sender, "ERROR.arena.not-found", "name", name);
            return;
        }
        String inUse = arena.isUsed() ? this.lang.getMessage("GENERAL.true") : this.lang.getMessage("GENERAL.false");
        String disabled = arena.isDisabled() ? this.lang.getMessage("GENERAL.true") : this.lang.getMessage("GENERAL.false");
        String kits = StringUtil.join(arena.getKits().stream().map(KitImpl::getName).collect(Collectors.toList()), ", ");
        String positions = StringUtil.join(arena.getPositions().values().stream().map(StringUtil::parse).collect(Collectors.toList()), ", ");
        String players = StringUtil.join(arena.getPlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList()), ", ");
        this.lang.sendMessage(sender, "COMMAND.duels.info", "name", name, "in_use", inUse, "disabled", disabled, "kits", !kits.isEmpty() ? kits : this.lang.getMessage("GENERAL.none"), "positions", !positions.isEmpty() ? positions : this.lang.getMessage("GENERAL.none"), "players", !players.isEmpty() ? players : this.lang.getMessage("GENERAL.none"));
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 2) {
            return this.handleTabCompletion(args[1], this.arenaManager.getNames());
        }
        return null;
    }
}

