/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.command.commands.duels.subcommands;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.api.user.User;
import me.realized.duels.command.BaseCommand;
import me.realized.duels.data.UserData;
import me.realized.duels.util.NumberUtil;
import me.realized.duels.util.function.TriFunction;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class EditCommand
extends BaseCommand {
    private final Map<String, Function<User, Integer>> getters = new HashMap<String, Function<User, Integer>>();
    private final Map<String, BiConsumer<User, Integer>> setters = new HashMap<String, BiConsumer<User, Integer>>();
    private final Map<String, TriFunction<User, String, Integer, Integer>> actions = new HashMap<String, TriFunction<User, String, Integer, Integer>>();

    public EditCommand(DuelsPlugin plugin) {
        super(plugin, "edit", "edit [name] [add:remove:set] [wins:losses] [amount]", "Edits player's wins or losses.", 5, false, new String[0]);
        this.getters.put("wins", User::getWins);
        this.getters.put("losses", User::getLosses);
        this.setters.put("wins", User::setWins);
        this.setters.put("losses", User::setLosses);
        this.actions.put("set", (user, type, amount) -> amount);
        this.actions.put("add", (user, type, amount) -> this.getters.get(type).apply((User)user) + amount);
        this.actions.put("remove", (user, type, amount) -> this.getters.get(type).apply((User)user) - amount);
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
        UserData user = this.userManager.get(args[1]);
        if (user == null) {
            this.lang.sendMessage(sender, "ERROR.data.not-found", "name", args[1]);
            return;
        }
        String actionName = args[2].toLowerCase();
        TriFunction<User, String, Integer, Integer> action = this.actions.get(actionName);
        if (action == null) {
            this.lang.sendMessage(sender, "ERROR.command.invalid-action", "action", actionName, "available_actions", this.actions.keySet());
            return;
        }
        String option = args[3].toLowerCase();
        BiConsumer<User, Integer> setter = this.setters.get(option);
        if (setter == null) {
            this.lang.sendMessage(sender, "ERROR.command.invalid-option", "option", option, "available_options", this.getters.keySet());
            return;
        }
        int amount = Math.max(NumberUtil.parseInt(args[4]).orElse(0), 0);
        setter.accept(user, action.apply(user, option, amount));
        this.lang.sendMessage(sender, "COMMAND.duels.edit", "name", user.getName(), "type", option, "action", actionName, "amount", amount);
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 3) {
            return this.actions.keySet().stream().filter(type -> type.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 4) {
            return this.setters.keySet().stream().filter(type -> type.toLowerCase().startsWith(args[3].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length > 4) {
            return Arrays.asList("0", "10", "50", "100", "500", "1000");
        }
        return null;
    }
}

