/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.command.commands.duels.subcommands;

import java.util.Arrays;
import java.util.List;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.command.BaseCommand;
import me.realized.duels.kit.KitImpl;
import me.realized.duels.queue.Queue;
import me.realized.duels.util.BlockUtil;
import me.realized.duels.util.NumberUtil;
import me.realized.duels.util.StringUtil;
import org.bukkit.Location;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AddsignCommand
extends BaseCommand {
    public AddsignCommand(DuelsPlugin plugin) {
        super(plugin, "addsign", "addsign [bet] [kit:-]", "Creates a queue sign with given bet and kit.", 3, true, new String[0]);
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
        String name;
        Player player = (Player)sender;
        Sign sign = BlockUtil.getTargetBlock(player, Sign.class, 6);
        if (sign == null) {
            this.lang.sendMessage(sender, "ERROR.sign.not-a-sign", new Object[0]);
            return;
        }
        int bet = NumberUtil.parseInt(args[1]).orElse(0);
        KitImpl kit = null;
        if (!args[2].equals("-") && (kit = this.kitManager.get(name = StringUtil.join(args, " ", 2, args.length).replace("-", " "))) == null) {
            this.lang.sendMessage(sender, "ERROR.kit.not-found", "name", name);
            return;
        }
        String kitName = kit != null ? kit.getName() : this.lang.getMessage("GENERAL.none");
        Queue queue = this.queueManager.get(kit, bet);
        if (queue == null) {
            this.lang.sendMessage(sender, "ERROR.queue.not-found", "bet_amount", bet, "kit", kitName);
            return;
        }
        if (!this.queueSignManager.create(player, sign.getLocation(), queue)) {
            this.lang.sendMessage(sender, "ERROR.sign.already-exists", new Object[0]);
            return;
        }
        Location location = sign.getLocation();
        this.lang.sendMessage(sender, "COMMAND.duels.add-sign", "location", StringUtil.parse(location), "kit", kitName, "bet_amount", bet);
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 2) {
            return Arrays.asList("0", "10", "50", "100", "500", "1000");
        }
        if (args.length > 2) {
            return this.handleTabCompletion(args[2], this.kitManager.getNames(true));
        }
        return null;
    }
}

