/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.command.commands.duel.subcommands;

import java.util.GregorianCalendar;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.api.kit.Kit;
import me.realized.duels.command.BaseCommand;
import me.realized.duels.data.UserData;
import me.realized.duels.util.DateUtil;
import me.realized.duels.util.TextBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StatsCommand
extends BaseCommand {
    public StatsCommand(DuelsPlugin plugin) {
        super(plugin, "stats", (String)null, (String)null, "duels.stats", 1, true, new String[0]);
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
        Player player = (Player)sender;
        if (args.length > this.getLength()) {
            if (!sender.hasPermission("duels.stats.others")) {
                this.lang.sendMessage(sender, "ERROR.no-permission", "permission", "duels.stats.others");
                return;
            }
            this.displayStats(player, args[1]);
            return;
        }
        this.displayStats(player, player.getName());
    }

    private void displayStats(Player sender, String name) {
        UserData user = this.userManager.get(name);
        if (user == null) {
            this.lang.sendMessage((CommandSender)sender, "ERROR.data.not-found", "name", name);
            return;
        }
        String wins = String.valueOf(user.getWins());
        String losses = String.valueOf(user.getLosses());
        String wlRatio = String.valueOf(user.getLosses() > 0 ? (double)Math.round((double)user.getWins() / (double)user.getLosses() * 100.0) / 100.0 : (double)user.getWins());
        String requests = String.valueOf(user.canRequest() ? this.lang.getMessage("GENERAL.enabled") : this.lang.getMessage("GENERAL.disabled"));
        Object[] args = new Object[]{"name", user.getName(), "wins", wins, "losses", losses, "wl_ratio", wlRatio, "requests_enabled", requests};
        this.lang.sendMessage((CommandSender)sender, "COMMAND.duel.stats.displayed", args);
        if (this.config.isDisplayKitRatings() || this.config.isDisplayNoKitRating()) {
            this.lang.sendMessage((CommandSender)sender, "COMMAND.duel.stats.rating.header", args);
            if (this.config.isDisplayNoKitRating()) {
                this.lang.sendMessage((CommandSender)sender, "COMMAND.duel.stats.rating.format", "type", this.config.getTopNoKitType(), "kit", this.config.getTopNoKitType(), "rating", user.getRating());
            }
            if (this.config.isDisplayKitRatings()) {
                this.kitManager.getKits().forEach(kit -> this.lang.sendMessage((CommandSender)sender, "COMMAND.duel.stats.rating.format", "type", kit.getName(), "kit", kit.getName(), "rating", user.getRating((Kit)kit)));
            }
            this.lang.sendMessage((CommandSender)sender, "COMMAND.duel.stats.rating.footer", args);
        }
        if (this.config.isDisplayPastMatches()) {
            this.lang.sendMessage((CommandSender)sender, "COMMAND.duel.stats.match.header", args);
            GregorianCalendar calendar = new GregorianCalendar();
            user.getMatches().forEach(match -> {
                String kit = match.getKit() != null ? match.getKit() : this.lang.getMessage("GENERAL.none");
                String duration = DateUtil.formatMilliseconds(match.getDuration());
                String timeSince = DateUtil.formatMilliseconds(calendar.getTimeInMillis() - match.getCreation());
                TextBuilder.of(this.lang.getMessage("COMMAND.duel.stats.match.format", "winner", match.getWinner(), "loser", match.getLoser())).setHoverEvent(HoverEvent.Action.SHOW_TEXT, this.lang.getMessage("COMMAND.duel.stats.match.hover-text", "kit", kit, "duration", duration, "time", timeSince, "health", match.getHealth())).send(sender);
            });
            this.lang.sendMessage((CommandSender)sender, "COMMAND.duel.stats.match.footer", args);
        }
    }
}

