/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.command.commands.duel.subcommands;

import me.realized.duels.DuelsPlugin;
import me.realized.duels.api.event.request.RequestAcceptEvent;
import me.realized.duels.command.BaseCommand;
import me.realized.duels.hook.hooks.CombatLogXHook;
import me.realized.duels.hook.hooks.CombatTagPlusHook;
import me.realized.duels.hook.hooks.PvPManagerHook;
import me.realized.duels.hook.hooks.worldguard.WorldGuardHook;
import me.realized.duels.request.RequestImpl;
import me.realized.duels.setting.Settings;
import me.realized.duels.util.inventory.InventoryUtil;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class AcceptCommand
extends BaseCommand {
    private final CombatTagPlusHook combatTagPlus;
    private final PvPManagerHook pvpManager;
    private final CombatLogXHook combatLogX;
    private final WorldGuardHook worldGuard;

    public AcceptCommand(DuelsPlugin plugin) {
        super(plugin, "accept", "accept [player]", "Accepts a duel request.", 2, true, new String[0]);
        this.combatTagPlus = this.hookManager.getHook(CombatTagPlusHook.class);
        this.pvpManager = this.hookManager.getHook(PvPManagerHook.class);
        this.combatLogX = plugin.getHookManager().getHook(CombatLogXHook.class);
        this.worldGuard = this.hookManager.getHook(WorldGuardHook.class);
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
        Player player = (Player)sender;
        if (this.config.isRequiresClearedInventory() && InventoryUtil.hasItem(player)) {
            this.lang.sendMessage(sender, "ERROR.duel.inventory-not-empty", new Object[0]);
            return;
        }
        if (this.config.isPreventCreativeMode() && player.getGameMode() == GameMode.CREATIVE) {
            this.lang.sendMessage(sender, "ERROR.duel.in-creative-mode", new Object[0]);
            return;
        }
        if (this.combatTagPlus != null && this.combatTagPlus.isTagged(player) || this.pvpManager != null && this.pvpManager.isTagged(player) || this.combatLogX != null && this.combatLogX.isTagged(player)) {
            this.lang.sendMessage(sender, "ERROR.duel.is-tagged", new Object[0]);
            return;
        }
        String duelzone = null;
        if (this.worldGuard != null && this.config.isDuelzoneEnabled() && (duelzone = this.worldGuard.findDuelZone(player)) == null) {
            this.lang.sendMessage(sender, "ERROR.duel.not-in-duelzone", "regions", this.config.getDuelzones());
            return;
        }
        if (this.arenaManager.isInMatch(player)) {
            this.lang.sendMessage(sender, "ERROR.duel.already-in-match.sender", new Object[0]);
            return;
        }
        if (this.spectateManager.isSpectating(player)) {
            this.lang.sendMessage(sender, "ERROR.spectate.already-spectating.sender", new Object[0]);
            return;
        }
        Player target = Bukkit.getPlayerExact((String)args[1]);
        if (target == null || !player.canSee(target)) {
            this.lang.sendMessage(sender, "ERROR.player.not-found", "name", args[1]);
            return;
        }
        RequestImpl request = this.requestManager.get(target, player);
        if (request == null) {
            this.lang.sendMessage(sender, "ERROR.duel.no-request", "name", target.getName());
            return;
        }
        RequestAcceptEvent event = new RequestAcceptEvent(player, target, request);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.requestManager.remove(target, player);
        if (this.arenaManager.isInMatch(target)) {
            this.lang.sendMessage(sender, "ERROR.duel.already-in-match.target", "name", target.getName());
            return;
        }
        if (this.spectateManager.isSpectating(target)) {
            this.lang.sendMessage(sender, "ERROR.spectate.already-spectating.target", "name", target.getName());
            return;
        }
        Settings settings = request.getSettings();
        String kit = settings.getKit() != null ? settings.getKit().getName() : this.lang.getMessage("GENERAL.not-selected");
        String arena = settings.getArena() != null ? settings.getArena().getName() : this.lang.getMessage("GENERAL.random");
        double bet = settings.getBet();
        String itemBetting = settings.isItemBetting() ? this.lang.getMessage("GENERAL.enabled") : this.lang.getMessage("GENERAL.disabled");
        this.lang.sendMessage((CommandSender)player, "COMMAND.duel.request.accept.receiver", "name", target.getName(), "kit", kit, "arena", arena, "bet_amount", bet, "item_betting", itemBetting);
        this.lang.sendMessage((CommandSender)target, "COMMAND.duel.request.accept.sender", "name", player.getName(), "kit", kit, "arena", arena, "bet_amount", bet, "item_betting", itemBetting);
        if (settings.isItemBetting()) {
            settings.setBaseLoc(player);
            settings.setDuelzone(player, duelzone);
            this.bettingManager.open(settings, target, player);
        } else {
            this.duelManager.startMatch(player, target, settings, null, null);
        }
    }
}

