/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.command.commands.duel;

import java.util.List;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.command.BaseCommand;
import me.realized.duels.command.commands.duel.subcommands.AcceptCommand;
import me.realized.duels.command.commands.duel.subcommands.DenyCommand;
import me.realized.duels.command.commands.duel.subcommands.InventoryCommand;
import me.realized.duels.command.commands.duel.subcommands.StatsCommand;
import me.realized.duels.command.commands.duel.subcommands.ToggleCommand;
import me.realized.duels.command.commands.duel.subcommands.TopCommand;
import me.realized.duels.command.commands.duel.subcommands.VersionCommand;
import me.realized.duels.data.UserData;
import me.realized.duels.hook.hooks.CombatLogXHook;
import me.realized.duels.hook.hooks.CombatTagPlusHook;
import me.realized.duels.hook.hooks.PvPManagerHook;
import me.realized.duels.hook.hooks.VaultHook;
import me.realized.duels.hook.hooks.worldguard.WorldGuardHook;
import me.realized.duels.kit.KitImpl;
import me.realized.duels.setting.Settings;
import me.realized.duels.util.NumberUtil;
import me.realized.duels.util.StringUtil;
import me.realized.duels.util.inventory.InventoryUtil;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DuelCommand
extends BaseCommand {
    private final CombatTagPlusHook combatTagPlus;
    private final PvPManagerHook pvpManager;
    private final CombatLogXHook combatLogX;
    private final WorldGuardHook worldGuard;
    private final VaultHook vault;

    public DuelCommand(DuelsPlugin plugin) {
        super(plugin, "duel", "duels.duel", true);
        this.child(new AcceptCommand(plugin), new DenyCommand(plugin), new StatsCommand(plugin), new ToggleCommand(plugin), new TopCommand(plugin), new InventoryCommand(plugin), new VersionCommand(plugin));
        this.combatTagPlus = this.hookManager.getHook(CombatTagPlusHook.class);
        this.pvpManager = this.hookManager.getHook(PvPManagerHook.class);
        this.combatLogX = this.hookManager.getHook(CombatLogXHook.class);
        this.worldGuard = this.hookManager.getHook(WorldGuardHook.class);
        this.vault = this.hookManager.getHook(VaultHook.class);
    }

    @Override
    protected boolean executeFirst(CommandSender sender, String label, String[] args) {
        Player player = (Player)sender;
        if (this.userManager.get(player) == null) {
            this.lang.sendMessage(sender, "ERROR.data.load-failure", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.lang.sendMessage(sender, "COMMAND.duel.usage", "command", label);
            return true;
        }
        if (this.isChild(args[0])) {
            return false;
        }
        if (this.config.isRequiresClearedInventory() && InventoryUtil.hasItem(player)) {
            this.lang.sendMessage(sender, "ERROR.duel.inventory-not-empty", new Object[0]);
            return true;
        }
        if (this.config.isPreventCreativeMode() && player.getGameMode() == GameMode.CREATIVE) {
            this.lang.sendMessage(sender, "ERROR.duel.in-creative-mode", new Object[0]);
            return true;
        }
        if (this.config.getBlacklistedWorlds().contains(player.getWorld().getName())) {
            this.lang.sendMessage(sender, "ERROR.duel.in-blacklisted-world", new Object[0]);
            return true;
        }
        if (this.combatTagPlus != null && this.combatTagPlus.isTagged(player) || this.pvpManager != null && this.pvpManager.isTagged(player) || this.combatLogX != null && this.combatLogX.isTagged(player)) {
            this.lang.sendMessage(sender, "ERROR.duel.is-tagged", new Object[0]);
            return true;
        }
        String duelzone = null;
        if (this.worldGuard != null && this.config.isDuelzoneEnabled() && (duelzone = this.worldGuard.findDuelZone(player)) == null) {
            this.lang.sendMessage(sender, "ERROR.duel.not-in-duelzone", "regions", this.config.getDuelzones());
            return true;
        }
        if (this.arenaManager.isInMatch(player)) {
            this.lang.sendMessage(sender, "ERROR.duel.already-in-match.sender", new Object[0]);
            return true;
        }
        if (this.spectateManager.isSpectating(player)) {
            this.lang.sendMessage(sender, "ERROR.spectate.already-spectating.sender", new Object[0]);
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null || !player.canSee(target)) {
            this.lang.sendMessage(sender, "ERROR.player.not-found", "name", args[0]);
            return true;
        }
        if (player.equals(target)) {
            this.lang.sendMessage(sender, "ERROR.duel.is-self", new Object[0]);
            return true;
        }
        UserData user = this.userManager.get(target);
        if (user == null) {
            this.lang.sendMessage(sender, "ERROR.data.not-found", "name", target.getName());
            return true;
        }
        if (!sender.hasPermission("duels.admin") && !user.canRequest()) {
            this.lang.sendMessage(sender, "ERROR.duel.requests-disabled", "name", target.getName());
            return true;
        }
        if (this.requestManager.has(player, target)) {
            this.lang.sendMessage(sender, "ERROR.duel.already-has-request", "name", target.getName());
            return true;
        }
        if (this.arenaManager.isInMatch(target)) {
            this.lang.sendMessage(sender, "ERROR.duel.already-in-match.target", "name", target.getName());
            return true;
        }
        if (this.spectateManager.isSpectating(target)) {
            this.lang.sendMessage(sender, "ERROR.spectate.already-spectating.target", "name", target.getName());
            return true;
        }
        Settings settings = this.settingManager.getSafely(player);
        settings.setBet(0);
        settings.setTarget(target);
        settings.setBaseLoc(player);
        settings.setDuelzone(player, duelzone);
        boolean sendRequest = false;
        if (args.length > 1) {
            int amount = NumberUtil.parseInt(args[1]).orElse(0);
            if (amount > 0 && this.config.isMoneyBettingEnabled()) {
                if (this.config.isMoneyBettingUsePermission() && !player.hasPermission("duels.use.money-betting") && !player.hasPermission("duels.use.*")) {
                    this.lang.sendMessage((CommandSender)player, "ERROR.no-permission", "permission", "duels.use.money-betting");
                    return true;
                }
                if (this.vault == null || this.vault.getEconomy() == null) {
                    this.lang.sendMessage(sender, "ERROR.setting.disabled-option", "option", this.lang.getMessage("GENERAL.betting"));
                    return true;
                }
                if (!this.vault.getEconomy().has((OfflinePlayer)player, (double)amount)) {
                    this.lang.sendMessage(sender, "ERROR.command.not-enough-money", new Object[0]);
                    return true;
                }
                settings.setBet(amount);
            }
            if (args.length > 2) {
                if (args[2].equalsIgnoreCase("true")) {
                    if (!this.config.isItemBettingEnabled()) {
                        this.lang.sendMessage((CommandSender)player, "ERROR.setting.disabled-option", "option", this.lang.getMessage("GENERAL.item-betting"));
                        return true;
                    }
                    if (this.config.isItemBettingUsePermission() && !player.hasPermission("duels.use.item-betting") && !player.hasPermission("duels.use.*")) {
                        this.lang.sendMessage((CommandSender)player, "ERROR.no-permission", "permission", "duels.use.item-betting");
                        return true;
                    }
                    settings.setItemBetting(true);
                }
                if (args.length > 3) {
                    if (args[3].equals("-")) {
                        if (!this.config.isOwnInventoryEnabled()) {
                            this.lang.sendMessage((CommandSender)player, "ERROR.setting.disabled-option", "option", this.lang.getMessage("GENERAL.own-inventory"));
                            return true;
                        }
                        if (this.config.isOwnInventoryUsePermission() && !player.hasPermission("duels.use.own-inventory") && !player.hasPermission("duels.use.*")) {
                            this.lang.sendMessage((CommandSender)player, "ERROR.no-permission", "permission", "duels.use.own-inventory");
                            return true;
                        }
                        settings.setOwnInventory(true);
                    } else {
                        if (!this.config.isKitSelectingEnabled()) {
                            this.lang.sendMessage((CommandSender)player, "ERROR.setting.disabled-option", "option", this.lang.getMessage("GENERAL.kit-selector"));
                            return true;
                        }
                        String name = StringUtil.join(args, " ", 3, args.length);
                        KitImpl kit = this.kitManager.get(name);
                        if (kit == null) {
                            this.lang.sendMessage(sender, "ERROR.kit.not-found", "name", name);
                            return true;
                        }
                        String permission = String.format("duels.kits.%s", name.replace(" ", "-").toLowerCase());
                        if (kit.isUsePermission() && !player.hasPermission("duels.kits.*") && !player.hasPermission(permission)) {
                            this.lang.sendMessage((CommandSender)player, "ERROR.no-permission", "permission", permission);
                            return true;
                        }
                        settings.setKit(kit);
                    }
                    sendRequest = true;
                }
            }
        }
        if (sendRequest) {
            this.requestManager.send(player, target, settings);
        } else if (this.config.isOwnInventoryEnabled()) {
            settings.openGui(player);
        } else {
            this.kitManager.getGui().open(player);
        }
        return true;
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return null;
    }
}

