/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.arena;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.realized.duels.api.match.Match;
import me.realized.duels.arena.ArenaImpl;
import me.realized.duels.kit.KitImpl;
import me.realized.duels.queue.Queue;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MatchImpl
implements Match {
    private final ArenaImpl arena;
    private final long start;
    private final KitImpl kit;
    private final Map<UUID, List<ItemStack>> items;
    private final int bet;
    private final Queue source;
    private boolean finished;
    private final Map<Player, Boolean> players = new HashMap<Player, Boolean>();

    MatchImpl(ArenaImpl arena, KitImpl kit, Map<UUID, List<ItemStack>> items, int bet, Queue source) {
        this.arena = arena;
        this.start = System.currentTimeMillis();
        this.kit = kit;
        this.items = items;
        this.bet = bet;
        this.source = source;
    }

    Map<Player, Boolean> getPlayerMap() {
        return this.players;
    }

    Set<Player> getAlivePlayers() {
        return this.players.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<Player> getAllPlayers() {
        return this.players.keySet();
    }

    public boolean isDead(Player player) {
        return this.players.getOrDefault(player, true);
    }

    public boolean isFromQueue() {
        return this.source != null;
    }

    public List<ItemStack> getItems() {
        return this.items != null ? this.items.values().stream().flatMap(Collection::stream).collect(Collectors.toList()) : Collections.emptyList();
    }

    void setFinished() {
        this.finished = true;
    }

    public long getDurationInMillis() {
        return System.currentTimeMillis() - this.start;
    }

    @Override
    @NotNull
    public List<ItemStack> getItems(@NotNull Player player) {
        Objects.requireNonNull(player, "player");
        if (this.items == null) {
            return Collections.emptyList();
        }
        List<ItemStack> items = this.items.get(player.getUniqueId());
        return items != null ? items : Collections.emptyList();
    }

    @Override
    @NotNull
    public Set<Player> getPlayers() {
        return Collections.unmodifiableSet(this.getAlivePlayers());
    }

    @Override
    @NotNull
    public Set<Player> getStartingPlayers() {
        return Collections.unmodifiableSet(this.getAllPlayers());
    }

    @Override
    public ArenaImpl getArena() {
        return this.arena;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public KitImpl getKit() {
        return this.kit;
    }

    @Override
    public int getBet() {
        return this.bet;
    }

    public Queue getSource() {
        return this.source;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }
}

