/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.arena;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.arena.ArenaImpl;
import me.realized.duels.config.Config;
import me.realized.duels.util.StringUtil;
import me.realized.duels.util.compat.Titles;
import me.realized.duels.util.function.Pair;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

class Countdown
extends BukkitRunnable {
    private final Config config;
    private final ArenaImpl arena;
    private final String kit;
    private final Map<UUID, Pair<String, Integer>> info;
    private final List<String> messages;
    private final List<String> titles;
    private boolean finished;

    Countdown(DuelsPlugin plugin, ArenaImpl arena, String kit, Map<UUID, Pair<String, Integer>> info, List<String> messages, List<String> titles) {
        this.config = plugin.getConfiguration();
        this.arena = arena;
        this.kit = kit;
        this.info = info;
        this.messages = Lists.newArrayList(messages);
        this.titles = Lists.newArrayList(titles);
    }

    public void run() {
        if (this.finished) {
            return;
        }
        String rawMessage = this.messages.remove(0);
        String message = StringUtil.color(rawMessage);
        String title = !this.titles.isEmpty() ? this.titles.remove(0) : null;
        this.arena.getPlayers().forEach(player -> {
            this.config.playSound((Player)player, rawMessage);
            Pair<String, Integer> info = this.info.get(player.getUniqueId());
            if (info != null) {
                player.sendMessage(message.replace("%opponent%", info.getKey()).replace("%opponent_rating%", String.valueOf(info.getValue())).replace("%kit%", this.kit).replace("%arena%", this.arena.getName()));
            } else {
                player.sendMessage(message);
            }
            if (title != null) {
                Titles.send(player, title, null, 0, 20, 50);
            }
        });
        if (!this.arena.isUsed() || this.messages.isEmpty()) {
            this.arena.setCountdown(null);
            this.cancel();
            this.finished = true;
        }
    }
}

