/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.arena;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.api.arena.Arena;
import me.realized.duels.api.event.arena.ArenaSetPositionEvent;
import me.realized.duels.api.event.arena.ArenaStateChangeEvent;
import me.realized.duels.api.event.match.MatchEndEvent;
import me.realized.duels.arena.Countdown;
import me.realized.duels.arena.MatchImpl;
import me.realized.duels.gui.BaseButton;
import me.realized.duels.kit.KitImpl;
import me.realized.duels.queue.Queue;
import me.realized.duels.setting.Settings;
import me.realized.duels.util.compat.Items;
import me.realized.duels.util.function.Pair;
import me.realized.duels.util.inventory.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArenaImpl
extends BaseButton
implements Arena {
    private final String name;
    private boolean disabled;
    private final Set<KitImpl> kits = new HashSet<KitImpl>();
    private final Map<Integer, Location> positions = new HashMap<Integer, Location>();
    private MatchImpl match;
    private Countdown countdown;
    private boolean removed;

    public ArenaImpl(DuelsPlugin plugin, String name, boolean disabled) {
        super(plugin, ItemBuilder.of(Items.EMPTY_MAP).name(plugin.getLang().getMessage("GUI.arena-selector.buttons.arena.name", "name", name)).lore(plugin.getLang().getMessage("GUI.arena-selector.buttons.arena.lore-unavailable").split("\n")).build());
        this.name = name;
        this.disabled = disabled;
    }

    public ArenaImpl(DuelsPlugin plugin, String name) {
        this(plugin, name, false);
    }

    public void refreshGui(boolean available) {
        this.setLore(this.lang.getMessage("GUI.arena-selector.buttons.arena.lore-" + (available ? "available" : "unavailable")).split("\n"));
        this.arenaManager.getGui().calculatePages();
    }

    @Override
    @Nullable
    public Location getPosition(int pos) {
        return this.positions.get(pos);
    }

    @Override
    public boolean setPosition(@Nullable Player source, int pos, @NotNull Location location) {
        Objects.requireNonNull(location, "location");
        if (pos <= 0 || pos > 2) {
            return false;
        }
        ArenaSetPositionEvent event = new ArenaSetPositionEvent((CommandSender)source, this, pos, location);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.positions.put(pos, location);
        this.arenaManager.saveArenas();
        this.refreshGui(this.isAvailable());
        return true;
    }

    @Override
    public boolean setPosition(int pos, @NotNull Location location) {
        return this.setPosition(null, pos, location);
    }

    @Override
    public boolean setDisabled(@Nullable CommandSender source, boolean disabled) {
        ArenaStateChangeEvent event = new ArenaStateChangeEvent(source, this, disabled);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.disabled = event.isDisabled();
        this.arenaManager.saveArenas();
        this.refreshGui(this.isAvailable());
        return true;
    }

    @Override
    public boolean setDisabled(boolean disabled) {
        return this.setDisabled(null, disabled);
    }

    public boolean isBoundless() {
        return this.kits.isEmpty();
    }

    public boolean isBound(@Nullable KitImpl kit) {
        return kit != null && this.kits.contains(kit);
    }

    public void bind(KitImpl kit) {
        if (this.isBound(kit)) {
            this.kits.remove(kit);
        } else {
            this.kits.add(kit);
        }
        this.arenaManager.saveArenas();
    }

    @Override
    public boolean isUsed() {
        return this.match != null;
    }

    public boolean isAvailable() {
        return !this.isDisabled() && !this.isUsed() && this.getPosition(1) != null && this.getPosition(2) != null;
    }

    public MatchImpl startMatch(KitImpl kit, Map<UUID, List<ItemStack>> items, int bet, Queue source) {
        this.match = new MatchImpl(this, kit, items, bet, source);
        this.refreshGui(false);
        return this.match;
    }

    public void endMatch(UUID winner, UUID loser, MatchEndEvent.Reason reason) {
        this.spectateManager.stopSpectating(this);
        MatchEndEvent event = new MatchEndEvent(this.match, winner, loser, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        Queue source = this.match.getSource();
        this.match.setFinished();
        this.match = null;
        if (source != null) {
            source.update();
            this.queueManager.getGui().calculatePages();
        }
        this.refreshGui(true);
    }

    public void startCountdown(String kit, Map<UUID, Pair<String, Integer>> info) {
        List<String> messages = this.config.getCdMessages();
        if (messages.isEmpty()) {
            return;
        }
        this.countdown = new Countdown((DuelsPlugin)this.plugin, this, kit, info, messages, this.config.getTitles());
        this.countdown.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    boolean isCounting() {
        return this.countdown != null;
    }

    @Override
    public boolean has(@NotNull Player player) {
        Objects.requireNonNull(player, "player");
        return this.isUsed() && this.match.getPlayerMap().getOrDefault(player, true) == false;
    }

    public void add(Player player) {
        if (this.isUsed()) {
            this.match.getPlayerMap().put(player, false);
        }
    }

    public void remove(Player player) {
        if (this.isUsed() && this.match.getPlayerMap().containsKey(player)) {
            this.match.getPlayerMap().put(player, true);
        }
    }

    public boolean isEndGame() {
        return this.size() <= 1;
    }

    public int size() {
        return this.isUsed() ? this.match.getAlivePlayers().size() : 0;
    }

    public Player first() {
        return this.isUsed() ? this.match.getAlivePlayers().iterator().next() : null;
    }

    public Player getOpponent(Player player) {
        return this.isUsed() ? (Player)this.match.getAllPlayers().stream().filter(other -> !player.equals(other)).findFirst().orElse(null) : null;
    }

    public Set<Player> getPlayers() {
        return this.isUsed() ? this.match.getAllPlayers() : Collections.emptySet();
    }

    public void broadcast(String message) {
        ArrayList receivers = Lists.newArrayList(this.getPlayers());
        this.spectateManager.getSpectatorsImpl(this).stream().map(spectator -> Bukkit.getPlayer((UUID)spectator.getUuid())).forEach(receivers::add);
        receivers.forEach(player -> player.sendMessage(message));
    }

    @Override
    public void onClick(Player player) {
        String kitName;
        if (!this.isAvailable()) {
            return;
        }
        Settings settings = this.settingManager.getSafely(player);
        String string = kitName = settings.getKit() != null ? settings.getKit().getName() : this.lang.getMessage("GENERAL.none");
        if (!this.arenaManager.isSelectable(settings.getKit(), this)) {
            this.lang.sendMessage((CommandSender)player, "ERROR.setting.arena-not-applicable", "kit", kitName, "arena", this.name);
            return;
        }
        settings.setArena(this);
        settings.openGui(player);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ArenaImpl arena = (ArenaImpl)other;
        return Objects.equals(this.name, arena.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public Set<KitImpl> getKits() {
        return this.kits;
    }

    public Map<Integer, Location> getPositions() {
        return this.positions;
    }

    @Override
    public MatchImpl getMatch() {
        return this.match;
    }

    Countdown getCountdown() {
        return this.countdown;
    }

    void setCountdown(Countdown countdown) {
        this.countdown = countdown;
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    void setRemoved(boolean removed) {
        this.removed = removed;
    }
}

