/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.realized.duels.api.Duels;
import me.realized.duels.api.command.SubCommand;
import me.realized.duels.arena.ArenaManagerImpl;
import me.realized.duels.betting.BettingManager;
import me.realized.duels.command.commands.SpectateCommand;
import me.realized.duels.command.commands.duel.DuelCommand;
import me.realized.duels.command.commands.duels.DuelsCommand;
import me.realized.duels.command.commands.queue.QueueCommand;
import me.realized.duels.config.Config;
import me.realized.duels.config.Lang;
import me.realized.duels.data.ItemData;
import me.realized.duels.data.UserManagerImpl;
import me.realized.duels.duel.DuelManager;
import me.realized.duels.extension.ExtensionClassLoader;
import me.realized.duels.extension.ExtensionManager;
import me.realized.duels.hook.HookManager;
import me.realized.duels.inventories.InventoryManager;
import me.realized.duels.kit.KitManagerImpl;
import me.realized.duels.listeners.DamageListener;
import me.realized.duels.listeners.EnderpearlListener;
import me.realized.duels.listeners.KitItemListener;
import me.realized.duels.listeners.KitOptionsListener;
import me.realized.duels.listeners.LingerPotionListener;
import me.realized.duels.listeners.PotionListener;
import me.realized.duels.listeners.ProjectileHitListener;
import me.realized.duels.listeners.TeleportListener;
import me.realized.duels.logging.LogManager;
import me.realized.duels.player.PlayerInfoManager;
import me.realized.duels.queue.QueueManager;
import me.realized.duels.queue.sign.QueueSignManagerImpl;
import me.realized.duels.request.RequestManager;
import me.realized.duels.setting.SettingsManager;
import me.realized.duels.shaded.bstats.Metrics;
import me.realized.duels.spectate.SpectateManagerImpl;
import me.realized.duels.teleport.Teleport;
import me.realized.duels.util.Loadable;
import me.realized.duels.util.Log;
import me.realized.duels.util.Reloadable;
import me.realized.duels.util.UpdateChecker;
import me.realized.duels.util.command.AbstractCommand;
import me.realized.duels.util.gui.GuiListener;
import me.realized.duels.util.json.JsonUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class DuelsPlugin
extends JavaPlugin
implements Duels,
Log.LogSource {
    private static final int BSTATS_ID = 2696;
    private static final int RESOURCE_ID = 20171;
    private static final String SPIGOT_INSTALLATION_URL = "https://www.spigotmc.org/wiki/spigot-installation/";
    private static DuelsPlugin instance;
    private final List<Loadable> loadables = new ArrayList<Loadable>();
    private int lastLoad;
    private LogManager logManager;
    private Config configuration;
    private Lang lang;
    private UserManagerImpl userManager;
    private GuiListener<DuelsPlugin> guiListener;
    private KitManagerImpl kitManager;
    private ArenaManagerImpl arenaManager;
    private SettingsManager settingManager;
    private PlayerInfoManager playerManager;
    private SpectateManagerImpl spectateManager;
    private BettingManager bettingManager;
    private InventoryManager inventoryManager;
    private DuelManager duelManager;
    private QueueManager queueManager;
    private QueueSignManagerImpl queueSignManager;
    private RequestManager requestManager;
    private HookManager hookManager;
    private Teleport teleport;
    private ExtensionManager extensionManager;
    private final Map<String, AbstractCommand<DuelsPlugin>> commands = new HashMap<String, AbstractCommand<DuelsPlugin>>();
    private final List<Listener> registeredListeners = new ArrayList<Listener>();
    private volatile boolean updateAvailable;
    private volatile String newVersion;

    public void onEnable() {
        instance = this;
        Log.addSource(this);
        JsonUtil.registerDeserializer(ItemData.class, ItemData.ItemDataDeserializer.class);
        try {
            this.logManager = new LogManager(this);
        }
        catch (IOException ex) {
            Log.error("Could not load LogManager. Please contact the developer.");
            ex.printStackTrace();
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        Log.addSource(this.logManager);
        this.logManager.debug("onEnable start -> " + System.currentTimeMillis() + "\n");
        try {
            Class.forName("org.spigotmc.SpigotConfig");
        }
        catch (ClassNotFoundException ex) {
            Log.error("================= *** DUELS LOAD FAILURE *** =================");
            Log.error("Duels requires a spigot server to run, but this server was not running on spigot!");
            Log.error("To run your server on spigot, follow this guide: https://www.spigotmc.org/wiki/spigot-installation/");
            Log.error("Spigot is compatible with CraftBukkit/Bukkit plugins.");
            Log.error("================= *** DUELS LOAD FAILURE *** =================");
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        this.configuration = new Config(this);
        this.loadables.add(this.configuration);
        this.lang = new Lang(this);
        this.loadables.add(this.lang);
        this.userManager = new UserManagerImpl(this);
        this.loadables.add(this.userManager);
        this.guiListener = new GuiListener<DuelsPlugin>(this);
        this.loadables.add(this.guiListener);
        this.kitManager = new KitManagerImpl(this);
        this.loadables.add(this.kitManager);
        this.arenaManager = new ArenaManagerImpl(this);
        this.loadables.add(this.arenaManager);
        this.settingManager = new SettingsManager(this);
        this.loadables.add(this.settingManager);
        this.playerManager = new PlayerInfoManager(this);
        this.loadables.add(this.playerManager);
        this.spectateManager = new SpectateManagerImpl(this);
        this.loadables.add(this.spectateManager);
        this.bettingManager = new BettingManager(this);
        this.loadables.add(this.bettingManager);
        this.inventoryManager = new InventoryManager(this);
        this.loadables.add(this.inventoryManager);
        this.duelManager = new DuelManager(this);
        this.loadables.add(this.duelManager);
        this.queueManager = new QueueManager(this);
        this.loadables.add(this.queueManager);
        this.queueSignManager = new QueueSignManagerImpl(this);
        this.loadables.add(this.queueSignManager);
        this.requestManager = new RequestManager(this);
        this.loadables.add(this.requestManager);
        this.hookManager = new HookManager(this);
        this.teleport = new Teleport(this);
        this.loadables.add(this.teleport);
        this.extensionManager = new ExtensionManager(this);
        this.loadables.add(this.extensionManager);
        if (!this.load()) {
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        new KitItemListener(this);
        new DamageListener(this);
        new PotionListener(this);
        new TeleportListener(this);
        new ProjectileHitListener(this);
        new EnderpearlListener(this);
        new KitOptionsListener(this);
        new LingerPotionListener(this);
        new Metrics(this, 2696);
        if (!this.configuration.isCheckForUpdates()) {
            return;
        }
        UpdateChecker updateChecker = new UpdateChecker(this, 20171);
        updateChecker.check((hasUpdate, newVersion) -> {
            if (hasUpdate.booleanValue()) {
                this.updateAvailable = true;
                this.newVersion = newVersion;
                Log.info("===============================================");
                Log.info("An update for " + this.getName() + " is available!");
                Log.info("Download " + this.getName() + " v" + newVersion + " here:");
                Log.info(this.getDescription().getWebsite());
                Log.info("===============================================");
            } else {
                Log.info("No updates were available. You are on the latest version!");
            }
        });
    }

    public void onDisable() {
        long start;
        long last = start = System.currentTimeMillis();
        this.logManager.debug("onDisable start -> " + start + "\n");
        this.unload();
        long l = last;
        last = System.currentTimeMillis();
        this.logManager.debug("unload done (took " + Math.abs(l - last) + "ms)");
        Log.clearSources();
        this.logManager.debug("Log#clearSources done (took " + Math.abs(last - System.currentTimeMillis()) + "ms)");
        this.logManager.handleDisable();
        instance = null;
        this.log(Level.INFO, "Disable process took " + (System.currentTimeMillis() - start) + "ms.");
    }

    private boolean load() {
        this.registerCommands(new DuelCommand(this), new QueueCommand(this), new SpectateCommand(this), new DuelsCommand(this));
        for (Loadable loadable : this.loadables) {
            String name = loadable.getClass().getSimpleName();
            try {
                long now = System.currentTimeMillis();
                this.logManager.debug("Starting load of " + name + " at " + now);
                loadable.handleLoad();
                this.logManager.debug(name + " has been loaded. (took " + (System.currentTimeMillis() - now) + "ms)");
                this.lastLoad = this.loadables.indexOf(loadable);
            }
            catch (Exception ex) {
                if (loadable instanceof Log.LogSource) {
                    ex.printStackTrace();
                }
                Log.error("There was an error while loading " + name + "! If you believe this is an issue from the plugin, please contact the developer.", ex);
                return false;
            }
        }
        return true;
    }

    private boolean unload() {
        this.registeredListeners.forEach(HandlerList::unregisterAll);
        this.registeredListeners.clear();
        HandlerList.getRegisteredListeners((Plugin)this).stream().filter(listener -> listener.getListener().getClass().getClassLoader().getClass().isAssignableFrom(ExtensionClassLoader.class)).forEach(listener -> HandlerList.unregisterAll((Listener)listener.getListener()));
        this.commands.clear();
        for (Loadable loadable : Lists.reverse(this.loadables)) {
            String name = loadable.getClass().getSimpleName();
            try {
                if (this.loadables.indexOf(loadable) > this.lastLoad) continue;
                long now = System.currentTimeMillis();
                this.logManager.debug("Starting unload of " + name + " at " + now);
                loadable.handleUnload();
                this.logManager.debug(name + " has been unloaded. (took " + (System.currentTimeMillis() - now) + "ms)");
            }
            catch (Exception ex) {
                Log.error("There was an error while unloading " + name + "! If you believe this is an issue from the plugin, please contact the developer.", ex);
                return false;
            }
        }
        return true;
    }

    @SafeVarargs
    private final void registerCommands(AbstractCommand<DuelsPlugin> ... commands) {
        for (AbstractCommand<DuelsPlugin> command : commands) {
            this.commands.put(command.getName().toLowerCase(), command);
            command.register();
        }
    }

    @Override
    public boolean registerSubCommand(@NotNull String command, final @NotNull SubCommand subCommand) {
        Objects.requireNonNull(command, "command");
        Objects.requireNonNull(subCommand, "subCommand");
        AbstractCommand<DuelsPlugin> result = this.commands.get(command.toLowerCase());
        if (result == null || result.isChild(subCommand.getName().toLowerCase())) {
            return false;
        }
        result.child(new AbstractCommand<DuelsPlugin>(this, subCommand){

            @Override
            protected void execute(CommandSender sender, String label, String[] args) {
                subCommand.execute(sender, label, args);
            }
        });
        return true;
    }

    @Override
    public void registerListener(@NotNull Listener listener) {
        Objects.requireNonNull(listener, "listener");
        this.registeredListeners.add(listener);
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)this);
    }

    @Override
    public boolean reload() {
        if (!this.unload() || !this.load()) {
            this.getPluginLoader().disablePlugin((Plugin)this);
            return false;
        }
        return true;
    }

    @Override
    public String getVersion() {
        return this.getDescription().getVersion();
    }

    public boolean reload(Loadable loadable) {
        boolean unloaded = false;
        try {
            loadable.handleUnload();
            unloaded = true;
            loadable.handleLoad();
            return true;
        }
        catch (Exception ex) {
            Log.error("There was an error while " + (unloaded ? "loading " : "unloading ") + loadable.getClass().getSimpleName() + "! If you believe this is an issue from the plugin, please contact the developer.", ex);
            return false;
        }
    }

    @Override
    public BukkitTask doSync(@NotNull Runnable task) {
        Objects.requireNonNull(task, "task");
        return Bukkit.getScheduler().runTask((Plugin)this, task);
    }

    @Override
    public BukkitTask doSyncAfter(@NotNull Runnable task, long delay) {
        Objects.requireNonNull(task, "task");
        return Bukkit.getScheduler().runTaskLater((Plugin)this, task, delay);
    }

    @Override
    public BukkitTask doSyncRepeat(@NotNull Runnable task, long delay, long period) {
        Objects.requireNonNull(task, "task");
        return Bukkit.getScheduler().runTaskTimer((Plugin)this, task, delay, period);
    }

    @Override
    public BukkitTask doAsync(@NotNull Runnable task) {
        Objects.requireNonNull(task, "task");
        return Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, task);
    }

    @Override
    public BukkitTask doAsyncAfter(@NotNull Runnable task, long delay) {
        Objects.requireNonNull(task, "task");
        return Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, task, delay);
    }

    @Override
    public BukkitTask doAsyncRepeat(@NotNull Runnable task, long delay, long period) {
        Objects.requireNonNull(task, "task");
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, task, delay, period);
    }

    @Override
    public void cancelTask(@NotNull BukkitTask task) {
        Objects.requireNonNull(task, "task");
        task.cancel();
    }

    @Override
    public void cancelTask(int id) {
        Bukkit.getScheduler().cancelTask(id);
    }

    @Override
    public void info(@NotNull String message) {
        Objects.requireNonNull(message, "message");
        Log.info(message);
    }

    @Override
    public void warn(@NotNull String message) {
        Objects.requireNonNull(message, "message");
        Log.warn(message);
    }

    @Override
    public void error(@NotNull String message) {
        Objects.requireNonNull(message, "message");
        Log.error(message);
    }

    @Override
    public void error(@NotNull String message, @NotNull Throwable thrown) {
        Objects.requireNonNull(message, "message");
        Objects.requireNonNull(thrown, "thrown");
        Log.error(message, thrown);
    }

    public Loadable find(String name) {
        return this.loadables.stream().filter(loadable -> loadable.getClass().getSimpleName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public List<String> getReloadables() {
        return this.loadables.stream().filter(loadable -> loadable instanceof Reloadable).map(loadable -> loadable.getClass().getSimpleName()).collect(Collectors.toList());
    }

    @Override
    public void log(Level level, String s) {
        this.getLogger().log(level, s);
    }

    @Override
    public void log(Level level, String s, Throwable thrown) {
        this.getLogger().log(level, s, thrown);
    }

    public static DuelsPlugin getInstance() {
        return instance;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public Config getConfiguration() {
        return this.configuration;
    }

    public Lang getLang() {
        return this.lang;
    }

    @Override
    public UserManagerImpl getUserManager() {
        return this.userManager;
    }

    public GuiListener<DuelsPlugin> getGuiListener() {
        return this.guiListener;
    }

    @Override
    public KitManagerImpl getKitManager() {
        return this.kitManager;
    }

    @Override
    public ArenaManagerImpl getArenaManager() {
        return this.arenaManager;
    }

    public SettingsManager getSettingManager() {
        return this.settingManager;
    }

    public PlayerInfoManager getPlayerManager() {
        return this.playerManager;
    }

    @Override
    public SpectateManagerImpl getSpectateManager() {
        return this.spectateManager;
    }

    public BettingManager getBettingManager() {
        return this.bettingManager;
    }

    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    public DuelManager getDuelManager() {
        return this.duelManager;
    }

    @Override
    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    @Override
    public QueueSignManagerImpl getQueueSignManager() {
        return this.queueSignManager;
    }

    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    public HookManager getHookManager() {
        return this.hookManager;
    }

    public Teleport getTeleport() {
        return this.teleport;
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getNewVersion() {
        return this.newVersion;
    }
}

