/*
 * Decompiled with CFR 0.152.
 */
package me.ronfarkash.elytraplus;

import java.util.HashMap;
import java.util.UUID;
import me.ronfarkash.elytraplus.ElytraPlus;
import me.ronfarkash.elytraplus.ParticleEffect;
import net.minecraft.server.v1_9_R1.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_9_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.util.Vector;

public class ElytraListener
implements Listener {
    ElytraPlus ep;
    HashMap<UUID, Long> boostCooldownMap = new HashMap();
    long boostcooldown;

    public ElytraListener(ElytraPlus ep) {
        this.ep = ep;
        this.boostcooldown = ep.getConfig().getLong("boost-cooldown");
    }

    @EventHandler
    public void glide(PlayerToggleSneakEvent e) {
        Player p = e.getPlayer();
        if (this.ep.inMode.contains(p.getUniqueId())) {
            EntityPlayer player = ((CraftPlayer)Bukkit.getPlayer((String)p.getName())).getHandle();
            Location pL = p.getEyeLocation();
            if (player.cB()) {
                if (!p.isSneaking()) {
                    if (!this.boostCooldownMap.containsKey(p.getUniqueId())) {
                        this.boostCooldownMap.put(p.getUniqueId(), System.currentTimeMillis() / 1000L + this.boostcooldown);
                        p.setVelocity(p.getLocation().getDirection().normalize().multiply(this.ep.getConfig().getDouble("boost-power")));
                        this.sonicBoomParticles(pL);
                    } else if (this.boostCooldownMap.get(p.getUniqueId()) <= System.currentTimeMillis() / 1000L) {
                        p.setVelocity(p.getLocation().getDirection().normalize().multiply(this.ep.getConfig().getDouble("boost-power")));
                        this.sonicBoomParticles(pL);
                        this.boostCooldownMap.remove(p.getUniqueId());
                        this.boostCooldownMap.put(p.getUniqueId(), System.currentTimeMillis() / 1000L + this.boostcooldown);
                    } else {
                        p.sendMessage(String.valueOf(this.ep.PREFIX) + " Boost is on cooldown.");
                    }
                }
            } else if (p.isOnGround()) {
                p.setVelocity(new Vector(0.0, this.ep.getConfig().getDouble("launch-power"), 0.0));
                this.launchParticles(pL.add(0.0, -1.3, 0.0));
                return;
            }
        } else {
            return;
        }
    }

    public void sonicBoomParticles(Location l) {
        double r = 0.0;
        while (r < 1.5) {
            double i = 0.0;
            while (i < 360.0) {
                double x = Math.cos(i) * (r * 0.7);
                double z = Math.sin(i) * (r * 1.0);
                Vector v = new Vector(x, 0.0, z);
                ElytraListener.rotateAroundAxisX(v, (l.getPitch() + 90.0f) * ((float)Math.PI / 180));
                ElytraListener.rotateAroundAxisY(v, -l.getYaw() * ((float)Math.PI / 180));
                l.add(v);
                ParticleEffect.CLOUD.display(0.0f, 0.0f, 0.0f, 0.01f, 1, l, 257.0);
                l.subtract(v);
                i += 2.0;
            }
            r += 0.3;
        }
    }

    public void launchParticles(Location l) {
        double i = 0.0;
        while (i < 360.0) {
            double x = Math.cos(i) * this.ep.getConfig().getDouble("launch-particles-radius");
            double z = Math.sin(i) * this.ep.getConfig().getDouble("launch-particles-radius");
            Vector v = new Vector(x, 0.0, z);
            l.add(v);
            ParticleEffect.CLOUD.display(0.0f, 0.0f, 0.0f, 0.01f, 1, l, 257.0);
            l.subtract(v);
            i += 2.0;
        }
    }

    @EventHandler
    public void collision(EntityDamageEvent e) {
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        if (this.ep.inMode.contains(e.getEntity().getUniqueId()) && this.ep.getConfig().getBoolean("cancel-collision-damage") && e.getCause() == EntityDamageEvent.DamageCause.FLY_INTO_WALL) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void quit(PlayerQuitEvent e) {
        if (this.ep.inMode.contains(e.getPlayer().getUniqueId())) {
            e.getPlayer().getInventory().setChestplate(null);
            this.boostCooldownMap.remove(e.getPlayer().getUniqueId());
            this.ep.inMode.remove(e.getPlayer().getUniqueId());
        }
    }

    @EventHandler
    public void move(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        if (this.ep.inMode.contains(p.getUniqueId())) {
            EntityPlayer player = ((CraftPlayer)Bukkit.getPlayer((String)p.getName())).getHandle();
            if (player.cB() && this.ep.getConfig().getBoolean("particles-while-flying")) {
                ParticleEffect.END_ROD.display(0.1f, 0.1f, 0.1f, 0.0f, 200, p.getLocation().add(p.getLocation().getDirection().multiply(-2)), 257.0);
            }
        } else {
            return;
        }
    }

    public static final Vector rotateAroundAxisX(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double y = v.getY() * cos - v.getZ() * sin;
        double z = v.getY() * sin + v.getZ() * cos;
        return v.setY(y).setZ(z);
    }

    public static final Vector rotateAroundAxisY(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos + v.getZ() * sin;
        double z = v.getX() * -sin + v.getZ() * cos;
        return v.setX(x).setZ(z);
    }
}

