/*
 * Decompiled with CFR 0.152.
 */
package nesancodev.com.xgui.gui;

import java.util.ArrayList;
import java.util.HashMap;
import nesancodev.com.xgui.component.Animation;
import nesancodev.com.xgui.component.Button;
import nesancodev.com.xgui.component.groups.AnimationGroup;
import nesancodev.com.xgui.enums.GUIType;
import nesancodev.com.xgui.listeners.InventoryClickListener;
import nesancodev.com.xgui.listeners.InventoryCloseListener;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;

public class GUI {
    private String title = "Title";
    private int size = 45;
    private GUIType type = GUIType.CHEST;
    private Inventory inventory;
    private String format;
    private HashMap<String, ItemStack> formatHashMap = new HashMap();
    private boolean isLocked = false;
    private HashMap<Integer, Button> buttonHashMap = new HashMap();
    private HashMap<Integer, Animation> animationHashMap = new HashMap();
    private HashMap<Inventory, BukkitRunnable> clickHashMap = new HashMap();
    private HashMap<Inventory, BukkitRunnable> closeHashMap = new HashMap();
    public static HashMap<Inventory, GUI> guiHashMap = new HashMap();

    public GUI(String title, GUIType type, int size) {
        this.title = title;
        this.type = type;
        this.size = size;
        this.inventory = Bukkit.createInventory(null, (int)size, (String)title);
        guiHashMap.put(this.inventory, this);
    }

    public GUI(String title, GUIType type) {
        this.title = title;
        this.type = type;
        this.inventory = Bukkit.createInventory(null, (int)this.size, (String)title);
        guiHashMap.put(this.inventory, this);
    }

    public GUI(String title) {
        this.title = title;
        this.inventory = Bukkit.createInventory(null, (int)this.size, (String)title);
        guiHashMap.put(this.inventory, this);
    }

    public GUI() {
        this.inventory = Bukkit.createInventory(null, (int)this.size, (String)this.title);
        guiHashMap.put(this.inventory, this);
    }

    public Inventory getDefaultInventory() {
        return this.inventory;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSize() {
        return this.size;
    }

    public ItemStack getItem(int slot) {
        return this.inventory.getItem(slot);
    }

    public void formatSlot(int slot, ItemStack item) {
        this.inventory.setItem(slot, item);
    }

    public void setSlot(int slot, ItemStack item) {
        this.inventory.setItem(slot, item);
    }

    public ArrayList<ItemStack> getAll(ItemStack stack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack x : this.inventory.getContents()) {
            if (x != stack) continue;
            stacks.add(x);
        }
        return stacks;
    }

    public ArrayList<ItemStack> getAll(Material material) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack x : this.inventory.getContents()) {
            if (x.getType() != material) continue;
            stacks.add(x);
        }
        return stacks;
    }

    public HashMap<Integer, ItemStack> getAll() {
        HashMap<Integer, ItemStack> stackHashMap = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            stackHashMap.put(i, this.inventory.getItem(i));
        }
        return stackHashMap;
    }

    public void remove(Integer i) {
        this.inventory.clear(i.intValue());
    }

    public void clear() {
        this.inventory.clear();
    }

    public GUIType getType() {
        return this.type;
    }

    public void lock() {
        this.isLocked = true;
    }

    public void unLock() {
        this.isLocked = false;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void border(ItemStack stack) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (i <= 8) {
                this.inventory.setItem(i, stack);
            }
            if (i >= this.getSize() - 8) {
                this.inventory.setItem(i, stack);
            }
            if (i == 9 || i == 18 || i == 27 || i == 36) {
                this.inventory.setItem(i, stack);
            }
            if (i != 17 && i != 26 && i != 35 && i != 44) continue;
            this.inventory.setItem(i, stack);
        }
    }

    public HashMap<Integer, Button> getButtonHashMap() {
        return this.buttonHashMap;
    }

    public HashMap<Integer, Animation> getAnimationHashMap() {
        return this.animationHashMap;
    }

    public HashMap<Inventory, BukkitRunnable> getClickHashMap() {
        return this.clickHashMap;
    }

    public HashMap<Inventory, BukkitRunnable> getCloseHashMap() {
        return this.closeHashMap;
    }

    public void open(Player player) {
        if (this.format != null) {
            for (int i = 0; i < this.format.length(); ++i) {
                String c = String.valueOf(this.format.charAt(i));
                if (this.formatHashMap.get(c) == null) continue;
                ItemStack stack = this.formatHashMap.get(c);
                this.inventory.setItem(i, stack);
            }
        }
        player.openInventory(this.inventory);
    }

    public void close(Player player) {
        player.closeInventory();
    }

    public void content(String format) {
        this.format = format;
    }

    public void addFormat(String text, ItemStack stack) {
        this.formatHashMap.put(text, stack);
    }

    public void addButton(int slot, Button button) {
        this.buttonHashMap.put(slot, button);
    }

    public void addAnimation(int slot, Animation animation) {
        this.animationHashMap.put(slot, animation);
        animation.setSlot(slot);
        animation.setGUI(this);
    }

    public void addAnimation(AnimationGroup animationGroup) {
        for (int i : animationGroup.getAnimationHashMap().keySet()) {
            Animation animation = animationGroup.getAnimationHashMap().get(i);
            animation.setGUI(this);
            this.animationHashMap.put(i, animation);
        }
    }

    public void onClick(BukkitRunnable runnable) {
        this.clickHashMap.put(this.inventory, runnable);
    }

    public void onClose(BukkitRunnable runnable) {
        this.closeHashMap.put(this.inventory, runnable);
    }

    public int getLastClickedSlot() {
        return InventoryClickListener.clickedSlotHashMap.get(this.inventory);
    }

    public Player getLastClicker() {
        return InventoryClickListener.clickerHashMap.get(this.inventory);
    }

    public ItemStack getLastClickedItem() {
        return InventoryClickListener.clickedItemHashMap.get(this.inventory);
    }

    public ClickType getLastClickType() {
        return InventoryClickListener.clickTypeHashMap.get(this.inventory);
    }

    public Player getLastCloser() {
        return InventoryCloseListener.closerHashMap.get(this.inventory);
    }
}

