/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.spigot.updater;

import dev.sergiferry.spigot.SpigotPlugin;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Scanner;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private SpigotPlugin plugin;

    public UpdateChecker(SpigotPlugin plugin) {
        this.plugin = plugin;
    }

    public void getLatestVersion(Consumer<String> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.plugin.getSpigotResourceID()).openStream();
                Scanner scanner = new Scanner(inputStream);
                if (scanner.hasNext()) {
                    consumer.accept(scanner.next());
                }
            }
            catch (IOException exception) {
                this.plugin.getServer().getConsoleSender().sendMessage("\u00a7cUnable to check for updates. Please visit " + this.plugin.getSpigotResource());
            }
        });
    }

    public void downloadLatestVersion() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                int bytesRead;
                BufferedInputStream in = new BufferedInputStream(new URL("https://api.spiget.org/v2/resources/" + this.plugin.getSpigotResourceID() + "/download").openStream());
                Method getFileMethod = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
                getFileMethod.setAccessible(true);
                File file = (File)getFileMethod.invoke((Object)this.plugin, new Object[0]);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] dataBuffer = new byte[1024];
                while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                    fileOutputStream.write(dataBuffer, 0, bytesRead);
                }
                this.plugin.getServer().getConsoleSender().sendMessage("\u00a7aThe latest update of " + this.plugin.getName() + " has been downloaded.");
                this.plugin.getServer().getConsoleSender().sendMessage("\u00a77Restarting server in 5 seconds to apply changes...");
                this.plugin.setUpdated();
            }
            catch (Exception exception) {
                this.plugin.getServer().getConsoleSender().sendMessage("\u00a7cUnable to download latest update. Please visit " + this.plugin.getSpigotResource());
                exception.printStackTrace();
            }
        });
    }
}

