/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.spigot.server;

import dev.sergiferry.spigot.SpigotPlugin;
import java.util.Arrays;

public enum ServerVersion {
    VERSION_1_17("1.17-R0.1-SNAPSHOT", 755),
    VERSION_1_17_1("1.17.1-R0.1-SNAPSHOT", 756),
    VERSION_1_18("1.18-R0.1-SNAPSHOT", 757),
    VERSION_1_18_1("1.18.1-R0.1-SNAPSHOT", 757),
    VERSION_1_18_2("1.18.2-R0.1-SNAPSHOT", 758),
    VERSION_1_19("1.19-R0.1-SNAPSHOT", 759),
    VERSION_1_19_1("1.19.1-R0.1-SNAPSHOT", 760),
    VERSION_1_19_2("1.19.2-R0.1-SNAPSHOT", 760),
    VERSION_1_19_3("1.19.3-R0.1-SNAPSHOT", 761),
    VERSION_1_19_4("1.19.4-R0.1-SNAPSHOT", 762);

    private String bukkitVersion;
    private int protocolVersion;

    private ServerVersion(String bukkitVersion, Integer protocolVersion) {
        this.bukkitVersion = bukkitVersion;
        this.protocolVersion = protocolVersion;
    }

    public String toString() {
        return this.getBukkitVersion();
    }

    public String getBukkitVersion() {
        return this.bukkitVersion;
    }

    public boolean isNewerThan(ServerVersion version) {
        return this.ordinal() > version.ordinal();
    }

    public boolean isNewerThanOrEqual(ServerVersion version) {
        return this.ordinal() >= version.ordinal();
    }

    public boolean isOlderThanOrEqual(ServerVersion version) {
        return this.ordinal() <= version.ordinal();
    }

    public boolean isOlderThan(ServerVersion version) {
        return this.ordinal() < version.ordinal();
    }

    public Integer getProtocolVersion() {
        return this.protocolVersion;
    }

    public Integer getOrder() {
        return this.ordinal();
    }

    public String getMinecraftVersion() {
        return this.bukkitVersion.split("-")[0];
    }

    public static ServerVersion getVersion(String version) {
        return Arrays.stream(ServerVersion.values()).filter(x -> x.getBukkitVersion().equals(version)).findAny().orElse(null);
    }

    public static ServerVersion getServerVersion() {
        return SpigotPlugin.getServerVersion();
    }

    public static ServerVersion getProtocolVersion(Integer protocolVersion) {
        return Arrays.stream(ServerVersion.values()).filter(x -> x.getProtocolVersion().equals(protocolVersion)).findFirst().orElse(null);
    }
}

