/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.spigot.nms.craftbukkit;

import dev.sergiferry.spigot.SpigotPlugin;
import dev.sergiferry.spigot.nms.NMSUtils;
import dev.sergiferry.spigot.server.ServerVersion;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import org.bukkit.entity.Player;

public class NMSCraftPlayer {
    private static Class<?> craftPlayerClass;
    private static Method craftPlayerGetHandle;
    private static Field playerConnectionField;
    private static Method sendPacketMethod;

    protected static void load() throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        craftPlayerClass = NMSUtils.getCraftBukkitClass("entity.CraftPlayer");
        craftPlayerGetHandle = craftPlayerClass.getMethod("getHandle", new Class[0]);
        playerConnectionField = craftPlayerGetHandle.getReturnType().getField("b");
        sendPacketMethod = SpigotPlugin.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_17_1) ? playerConnectionField.getType().getMethod("sendPacket", Packet.class) : playerConnectionField.getType().getMethod("a", Packet.class);
    }

    public static PlayerConnection getPlayerConnection(Player player) {
        try {
            return (PlayerConnection)NMSCraftPlayer.getPlayerConnectionField().get(NMSCraftPlayer.getEntityPlayer(player));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error at NMSCraftPlayer");
        }
    }

    public static EntityPlayer getEntityPlayer(Player player) {
        try {
            return (EntityPlayer)NMSCraftPlayer.getCraftPlayerGetHandle().invoke(NMSCraftPlayer.getCraftPlayerClass().cast(player), new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error at NMSCraftPlayer");
        }
    }

    public static void sendPacket(Player player, Packet packet) {
        NMSCraftPlayer.sendPacket(NMSCraftPlayer.getPlayerConnection(player), packet);
    }

    public static void sendPacket(PlayerConnection playerConnection, Packet packet) {
        try {
            sendPacketMethod.invoke((Object)playerConnection, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Class<?> getCraftPlayerClass() {
        return craftPlayerClass;
    }

    public static Method getCraftPlayerGetHandle() {
        return craftPlayerGetHandle;
    }

    public static Field getPlayerConnectionField() {
        return playerConnectionField;
    }

    public static Method getSendPacketMethod() {
        return sendPacketMethod;
    }
}

