/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.utils;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Random;

public class MathUtils {
    public static Integer random(int start, int end) {
        Random r = new Random();
        return start + r.nextInt(end - start + 1);
    }

    public static DecimalFormat getDecimalFormat(int decimals) {
        DecimalFormat formatea = new DecimalFormat("#,###,##0.00");
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
        otherSymbols.setDecimalSeparator('.');
        otherSymbols.setGroupingSeparator(',');
        formatea.setDecimalFormatSymbols(otherSymbols);
        formatea.setRoundingMode(RoundingMode.FLOOR);
        formatea.setMinimumFractionDigits(decimals);
        formatea.setMaximumFractionDigits(decimals);
        return formatea;
    }

    public static String getFormat(double d) {
        return MathUtils.getFormat(d, 2);
    }

    public static String getFormat(double d, int decimals) {
        return MathUtils.getDecimalFormat(decimals).format(d);
    }

    public static String getFormat(int i) {
        return MathUtils.getFormat(i, 2);
    }

    public static String getFormat(int i, int decimals) {
        return MathUtils.getDecimalFormat(decimals).format(i);
    }

    public static Double distance(int x1, int z1, int x2, int z2) {
        int minX = Math.min(x1, x2);
        int maxX = Math.max(x1, x2);
        int minZ = Math.min(z1, z2);
        int maxZ = Math.max(z1, z2);
        int xd = maxX - minX;
        int zd = maxZ - minZ;
        return Math.sqrt(xd * xd + zd * zd);
    }
}

