/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.utils;

import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;

public class LocationUtils {
    public static boolean isOutsideOfBorder(World world, Double locX, Double locZ) {
        WorldBorder border = world.getWorldBorder();
        double size = border.getSize() / 2.0;
        Location center = border.getCenter();
        double x = locX - center.getX();
        double z = locZ - center.getZ();
        return x > size || -x > size || z > size || -z > size;
    }

    public static String serialize(Location location) {
        return location.getWorld().getName() + "|" + location.getX() + "|" + location.getY() + "|" + location.getZ() + "|" + location.getYaw() + "|" + location.getPitch();
    }

    public static String serializeBlock(Location location) {
        return location.getWorld().getName() + "|" + (double)location.getBlockX() + "|" + (double)location.getBlockY() + "|" + (double)location.getBlockZ();
    }

    public static Location serialize(String world, Double x, Double y, Double z, Float yaw, Float pitch) {
        return new Location(Bukkit.getWorld((String)world), x.doubleValue(), y.doubleValue(), z.doubleValue(), yaw.floatValue(), pitch.floatValue());
    }

    public static Location serialize(World world, Double x, Double y, Double z, Float yaw, Float pitch) {
        return new Location(world, x.doubleValue(), y.doubleValue(), z.doubleValue(), yaw.floatValue(), pitch.floatValue());
    }

    public static Location serialize(String location) {
        String separator = Pattern.quote("|");
        String[] loc = location.split(separator);
        World world = Bukkit.getWorld((String)loc[0]);
        Double x = Double.parseDouble(loc[1]);
        Double y = Double.parseDouble(loc[2]);
        Double z = Double.parseDouble(loc[3]);
        Float yaw = Float.valueOf(Float.parseFloat(loc[4]));
        Float pitch = Float.valueOf(Float.parseFloat(loc[5]));
        return new Location(world, x.doubleValue(), y.doubleValue(), z.doubleValue(), yaw.floatValue(), pitch.floatValue());
    }

    public static Location serializeBlock(String location) {
        String separator = Pattern.quote("|");
        String[] loc = location.split(separator);
        World world = Bukkit.getWorld((String)loc[0]);
        Double x = Double.parseDouble(loc[1]);
        Double y = Double.parseDouble(loc[2]);
        Double z = Double.parseDouble(loc[3]);
        return new Location(world, x.doubleValue(), y.doubleValue(), z.doubleValue());
    }

    public static String getReplacedWorldName(String world) {
        if (world.contains("_nether")) {
            return "Nether";
        }
        if (world.contains("_the_end")) {
            return "End";
        }
        return world.substring(0, 1).toUpperCase() + world.substring(1).replaceAll("_", " ");
    }

    public static int floor(double num) {
        int floor = (int)num;
        return (double)floor == num ? floor : floor - (int)(Double.doubleToRawLongBits(num) >>> 63);
    }
}

