/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public class ItemBuilder {
    private ItemStack is;
    private ItemMeta meta;

    public ItemBuilder(Material m, Integer amount, Short durability) {
        this.is = new ItemStack(m, amount.intValue(), durability.shortValue());
        this.meta = this.is.getItemMeta();
    }

    public ItemBuilder(Material m, Integer amount) {
        this.is = new ItemStack(m, amount.intValue());
        this.meta = this.is.getItemMeta();
    }

    public ItemBuilder(Material m) {
        this(m, (Integer)1);
    }

    public ItemBuilder(ItemStack is) {
        this.is = is.clone();
        this.meta = this.is.getItemMeta();
    }

    public ItemBuilder(ItemStack is, Integer amount) {
        ItemStack itemStack = new ItemStack(is.getType(), amount.intValue());
        itemStack.setItemMeta(is.getItemMeta());
        this.is = itemStack;
        this.meta = this.is.getItemMeta();
    }

    public ItemStack getItemStack() {
        if (this.meta != null) {
            this.is.setItemMeta(this.meta);
        }
        return this.is;
    }

    public ItemBuilder hideAttributes() {
        this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_UNBREAKABLE, ItemFlag.HIDE_DYE, ItemFlag.HIDE_DESTROYS, ItemFlag.HIDE_PLACED_ON, ItemFlag.HIDE_POTION_EFFECTS});
        return this;
    }

    public ItemBuilder setDescription(String ... s) {
        this.setName(s[0]);
        if (s.length > 1) {
            ArrayList<String> lore = new ArrayList<String>();
            for (int i = 1; i < s.length; ++i) {
                lore.add(s[i]);
            }
            this.setLore(lore);
        }
        return this;
    }

    public ItemBuilder addPersistentData(NamespacedKey namespacedKey, PersistentDataType persistentDataType, Object o) {
        this.meta.getPersistentDataContainer().set(namespacedKey, persistentDataType, o);
        return this;
    }

    public ItemBuilder setDescription(List<String> s) {
        this.setName(s.get(0));
        if (s.size() > 1) {
            ArrayList<String> lore = new ArrayList<String>();
            for (int i = 1; i < s.size(); ++i) {
                lore.add(s.get(i));
            }
            this.setLore(lore);
        }
        return this;
    }

    public ItemBuilder setName(String s) {
        this.meta.setDisplayName(s);
        return this;
    }

    public ItemBuilder setDamage(Integer s) {
        if (this.is.getType().getMaxDurability() < s) {
            this.is = new ItemStack(Material.AIR);
            this.meta = null;
            return this;
        }
        Damageable im = (Damageable)this.meta;
        im.setDamage(s.intValue());
        return this;
    }

    public ItemBuilder addDamage(Integer s) {
        Damageable im = (Damageable)this.meta;
        this.setDamage(im.getDamage() + s);
        return this;
    }

    public ItemBuilder removeDamage(Integer s) {
        Damageable im = (Damageable)this.meta;
        this.setDamage(im.getDamage() - s);
        return this;
    }

    public ItemBuilder setLore(String ... s) {
        this.meta.setLore(Arrays.asList(s));
        return this;
    }

    public ItemBuilder setLore(List<String> s) {
        this.meta.setLore(s);
        return this;
    }

    public ItemBuilder setOwner(Player player) {
        return this.setOwner(player.getName());
    }

    public ItemBuilder setOwner(String s) {
        if (this.is.getType().equals((Object)Material.PLAYER_HEAD) && this.meta instanceof SkullMeta) {
            ((SkullMeta)this.meta).setOwner(s);
        }
        return this;
    }

    public ItemBuilder setSkullTexture(String s) {
        SkullMeta im = (SkullMeta)this.meta;
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", s));
        Field profileField = null;
        try {
            profileField = im.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(im, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e1) {
            e1.printStackTrace();
        }
        return this;
    }

    public ItemBuilder setLeatherColor(Color c) {
        if (this.meta instanceof LeatherArmorMeta) {
            ((LeatherArmorMeta)this.meta).setColor(c);
        }
        return this;
    }

    public ItemBuilder setPotionType(PotionType potionType) {
        if (this.meta instanceof PotionMeta) {
            ((PotionMeta)this.meta).setBasePotionData(new PotionData(potionType));
        }
        return this;
    }

    public ItemBuilder addPottionEffect(PotionEffect potionEffect, boolean b) {
        if (this.meta instanceof PotionMeta) {
            ((PotionMeta)this.meta).addCustomEffect(potionEffect, b);
        }
        return this;
    }

    public ItemBuilder setPotionColor(Color color) {
        if (this.meta instanceof PotionMeta) {
            ((PotionMeta)this.meta).setColor(color);
        }
        return this;
    }

    public ItemBuilder setEnchanted() {
        this.meta.addEnchant(Enchantment.DURABILITY, 1, false);
        return this;
    }

    public ItemBuilder setEnchanted(boolean b) {
        if (b) {
            this.meta.addEnchant(Enchantment.DURABILITY, 1, false);
        }
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment en, Integer level) {
        if (en == null || level <= 0) {
            return this;
        }
        if (this.is.getType().equals((Object)Material.ENCHANTED_BOOK)) {
            ((EnchantmentStorageMeta)this.meta).addStoredEnchant(en, level.intValue(), true);
        } else {
            this.meta.addEnchant(en, level.intValue(), true);
        }
        return this;
    }

    public ItemBuilder removeEnchantment(Enchantment en, Integer level) {
        if (this.meta.hasEnchant(en)) {
            this.meta.removeEnchant(en);
        }
        return this;
    }

    public ItemBuilder setUnbreakable() {
        this.meta.setUnbreakable(true);
        return this;
    }

    public ItemBuilder setBaseColor(DyeColor d) {
        if (this.is.getType().name().contains("_BANNER") && this.meta instanceof BannerMeta) {
            ((BannerMeta)this.meta).setBaseColor(d);
        }
        return this;
    }

    public ItemBuilder addPatern(Pattern p) {
        if (this.is.getType().name().contains("_BANNER") && this.meta instanceof BannerMeta) {
            ((BannerMeta)this.meta).addPattern(p);
        }
        return this;
    }

    public ItemBuilder setShieldColor(DyeColor d) {
        if (this.is.getType().equals((Object)Material.SHIELD)) {
            BlockStateMeta blockStateMeta = (BlockStateMeta)this.meta;
            BlockState blockState = blockStateMeta.getBlockState();
            if (blockState instanceof Banner) {
                Banner banner = (Banner)blockState;
                banner.setBaseColor(d);
            }
            blockStateMeta.setBlockState(blockState);
        }
        return this;
    }
}

