/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.teleportation.handlers.npc;

import com.mojang.datafixers.util.Pair;
import dev.sergiferry.playernpc.api.NPC;
import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.randomtp.RandomTeleportPlugin;
import dev.sergiferry.randomtp.config.ConfigManager;
import dev.sergiferry.randomtp.config.PathValue;
import dev.sergiferry.randomtp.integration.IntegrationsManager;
import dev.sergiferry.randomtp.messages.MessagesManager;
import dev.sergiferry.randomtp.player.PlayerManager;
import dev.sergiferry.randomtp.teleportation.TeleportationHandler;
import dev.sergiferry.randomtp.teleportation.WorldOptions;
import dev.sergiferry.randomtp.utils.ColorUtils;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class RandomTPNPC {
    protected NPC.Global npc;
    private Type type;
    private ConfigurationSection section;
    private Integer id;
    private World destination;
    @ColorUtils.Colored(colored=false)
    private String alias;
    private Location location;
    private NPC.Skin.Custom npcSkin;
    private String permission;
    private ChatColor glowingColor;
    private Double cancelDistance;
    private Boolean followGaze;
    private Boolean collidable;

    protected RandomTPNPC(Integer id, Type type, ConfigurationSection section) {
        this.id = id;
        this.type = type;
        Validate.isTrue((boolean)type.name().equalsIgnoreCase(Value.TYPE.get(section)), (String)"NPC-Type does not correspond");
        this.section = section;
        String worldName = Value.DESTINATION.get(section);
        if (!WorldOptions.isValid(worldName)) {
            throw new IllegalStateException();
        }
        this.destination = Bukkit.getWorld((String)worldName);
        Validate.notNull((Object)this.destination, (String)"This world do no exists.");
        String skinValue = Value.SKIN_VALUE.get(section);
        String skinSignature = Value.SKIN_SIGNATURE.get(section);
        this.alias = Value.ALIAS.get(section);
        this.location = Value.LOCATION.get(section);
        this.permission = Value.PERMISSION.get(section);
        this.followGaze = Value.FOLLOW_GAZE.get(section);
        this.collidable = Value.COLLIDABLE.get(section);
        this.cancelDistance = Value.CANCEL_DISTANCE.get(section);
        String glowingColorName = Value.GLOWING_COLOR.get(section);
        this.glowingColor = glowingColorName.equalsIgnoreCase("NONE") ? null : ChatColor.valueOf((String)glowingColorName);
        ConfigManager.setComments(ConfigManager.CONFIG.getFileConfiguration(), section, Value.TYPE.getPath(), Arrays.asList("There are 2 types of NPCs. The Personal NPC will only allow you to teleport 1 person at a time, while the Group NPC will allow you to teleport a group of people who are near the NPC.", "Types: PERSONAL, GROUP"));
        ConfigManager.setComments(ConfigManager.CONFIG.getFileConfiguration(), section, Value.DESTINATION.getPath(), "This will be the destination world where the NPC will search for a random location.");
        ConfigManager.setComments(ConfigManager.CONFIG.getFileConfiguration(), section, Value.GLOWING_COLOR.getPath(), Arrays.asList("While the NPC is looking for a random location, it will be highlighted in this color.", "List of colors: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/ChatColor.html"));
        Optional customSkin = NPC.Skin.Custom.getLoadedSkin((Plugin)RandomTeleportPlugin.getInstance(), (String)id.toString());
        if (customSkin.isPresent()) {
            ((NPC.Skin.Custom)customSkin.get()).delete();
        }
        this.npcSkin = NPC.Skin.Custom.createCustomSkin((Plugin)RandomTeleportPlugin.getInstance(), (String)id.toString(), (String)skinValue, (String)skinSignature);
        this.create();
    }

    public void create() {
        NPCLib.getInstance().grabGlobalNPC((Plugin)RandomTeleportPlugin.getInstance(), this.getId().toString()).ifPresent(global -> NPCLib.getInstance().removeGlobalNPC(global));
        this.npc = NPCLib.getInstance().generateGlobalNPC((Plugin)RandomTeleportPlugin.getInstance(), this.id.toString(), this.location);
        this.npc.setSkin(this.getSkin());
        this.applyGlowingColor();
        this.applyCollidable();
        this.applyFollowGaze();
    }

    public void remove() {
        if (this.npc != null && NPCLib.getInstance().getAllGlobalNPCs().contains(this.npc)) {
            NPCLib.getInstance().removeGlobalNPC(this.npc);
        }
        TeleportationHandler.unregisterTeleportationHandler(this);
        this.npc = null;
    }

    public abstract void setIdle(Player var1);

    public abstract void setSearching(Player var1);

    public void removeConfirmation(Player player) {
        PlayerManager.confirmAction(player, p -> {
            IntegrationsManager.getPlayerNPC().removeNPC(this);
            MessagesManager.Message.PLAYERNPC_COMMAND_REMOVE_SUCCESS.sendMessage((CommandSender)p, new Pair[0]);
        }, MessagesManager.placeholder(MessagesManager.Message.GUI_CONFIRMATION_QUESTION_REMOVE_NPC.getValue(player), Pair.of((Object)"id", (Object)("#" + this.id)), Pair.of((Object)"world", (Object)this.getColoredAlias())));
    }

    public void error(Player player) {
        if (this.npc == null) {
            return;
        }
        this.npc.playAnimation(player, NPC.Animation.TAKE_DAMAGE);
        player.playSound(this.npc.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
    }

    public NPC.Global getNPC() {
        return this.npc;
    }

    public Integer getId() {
        return this.id;
    }

    public World getDestination() {
        return this.destination;
    }

    public Location getLocation() {
        return this.location;
    }

    public NPC.Skin getSkin() {
        return this.npcSkin;
    }

    @ColorUtils.Colored(colored=false)
    public String getAlias() {
        return this.alias;
    }

    @ColorUtils.Colored(colored=true)
    public String getColoredAlias() {
        return this.alias.equals("none") ? ColorUtils.color(this.getWorldOptions().getAlias()) : ColorUtils.color(this.alias);
    }

    public WorldOptions getWorldOptions() {
        return WorldOptions.of(this.destination);
    }

    public String getPermission() {
        return this.permission;
    }

    public ChatColor getGlowingColor() {
        return this.glowingColor;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public void setAlias(String alias) {
        if (alias == null) {
            alias = "none";
        }
        this.alias = alias;
        this.updateAttributes(false);
    }

    public Double getCancelDistance() {
        return this.cancelDistance;
    }

    public void setCancelDistance(Double cancelDistance) {
        this.cancelDistance = cancelDistance;
        this.updateAttributes();
    }

    public void setSkin(String texture, String signature) {
        this.npcSkin.changeTexture((Plugin)RandomTeleportPlugin.getInstance(), texture, signature);
        this.applySkin();
        this.updateAttributes();
    }

    private void applySkin() {
        this.npc.setSkin((NPC.Skin)this.npcSkin);
    }

    public void setDestination(World destination) {
        this.destination = destination;
        this.npc.getPlayers().forEach(x -> this.setIdle((Player)x));
        this.updateAttributes(false);
    }

    public void setGlowingColor(ChatColor glowingColor) {
        this.glowingColor = glowingColor;
        this.applyGlowingColor();
        this.updateAttributes();
    }

    private void applyGlowingColor() {
        this.npc.setGlowingColor(this.glowingColor);
        this.npc.setTextItemGlowingColor(this.glowingColor);
    }

    public void setFollowGaze(Boolean followGaze) {
        this.followGaze = followGaze;
        this.applyFollowGaze();
        this.updateAttributes();
    }

    private void applyFollowGaze() {
        this.npc.setGazeTrackingType(this.followGaze != false ? NPC.GazeTrackingType.PLAYER : NPC.GazeTrackingType.NONE);
    }

    public void setCollidable(Boolean collidable) {
        this.collidable = collidable;
        this.applyCollidable();
        this.updateAttributes();
    }

    private void applyCollidable() {
        this.npc.setCollidable(this.collidable.booleanValue());
    }

    public void updateAttributes() {
        this.updateAttributes(true);
    }

    public void updateAttributes(boolean update) {
        if (update) {
            this.npc.update();
        }
        Value.SKIN_VALUE.set(this.section, this.npcSkin.getTexture());
        Value.SKIN_SIGNATURE.set(this.section, this.npcSkin.getSignature());
        Value.DESTINATION.set(this.section, this.destination.getName());
        Value.GLOWING_COLOR.set(this.section, this.glowingColor != null ? this.glowingColor.name() : "NONE");
        Value.FOLLOW_GAZE.set(this.section, this.followGaze);
        Value.COLLIDABLE.set(this.section, this.collidable);
        Value.CANCEL_DISTANCE.set(this.section, this.cancelDistance);
        try {
            ConfigManager.CONFIG.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cancelSearchTasks() {
        this.getHandler().cancelSearchTasks();
        this.npc.getPlayers().forEach(x -> this.setIdle((Player)x));
    }

    public abstract TeleportationHandler<RandomTPNPC> getHandler();

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        PERSONAL,
        GROUP;

    }

    public static class Value<T>
    extends PathValue<T> {
        public static final Value<String> TYPE = new Value<String>("type", String.class, Type.PERSONAL.name());
        public static final Value<String> DESTINATION = new Value<String>("destination", String.class);
        public static final Value<String> ALIAS = new Value<String>("alias", String.class, "none");
        public static final Value<String> SKIN_VALUE = new Value<String>("skin.value", String.class);
        public static final Value<String> SKIN_SIGNATURE = new Value<String>("skin.signature", String.class);
        public static final Value<Location> LOCATION = new Value<Location>("location", Location.class);
        public static final Value<String> PERMISSION = new Value<String>("permission", String.class, "randomtp.use.npc");
        public static final Value<String> GLOWING_COLOR = new Value<String>("glowing-color", String.class);
        public static final Value<Double> CANCEL_DISTANCE = new Value<Double>("cancel-distance", Double.class, 0.0);
        public static final Value<Boolean> FOLLOW_GAZE = new Value<Boolean>("follow-gaze", Boolean.class, true);
        public static final Value<Boolean> COLLIDABLE = new Value<Boolean>("collidable", Boolean.class, true);
        private T def;

        private Value(String path, Class<T> type) {
            super(path, type);
        }

        private Value(String path, Class<T> type, T def) {
            this(path, type);
            this.def = def;
        }

        @Override
        public T get(ConfigurationSection configurationSection) {
            if (this.def != null && !configurationSection.contains(this.getPath()) || !configurationSection.get(this.getPath()).getClass().equals(this.getType())) {
                configurationSection.set(this.getPath(), this.def);
            }
            return (T)configurationSection.getObject(this.getPath(), this.getType());
        }

        public T get(RandomTPNPC npc) {
            return this.get(npc.section);
        }

        public T getDefault() {
            return this.def;
        }

        public boolean hasDefault() {
            return this.def != null;
        }
    }
}

