/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.teleportation.handlers.npc;

import com.mojang.datafixers.util.Pair;
import dev.sergiferry.playernpc.api.NPC;
import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.randomtp.RandomTeleportPlugin;
import dev.sergiferry.randomtp.config.ConfigValue;
import dev.sergiferry.randomtp.messages.MessagesManager;
import dev.sergiferry.randomtp.player.PermissionsManager;
import dev.sergiferry.randomtp.teleportation.PersonalTeleportationHandler;
import dev.sergiferry.randomtp.teleportation.SearchTask;
import dev.sergiferry.randomtp.teleportation.TeleportationHandler;
import dev.sergiferry.randomtp.teleportation.handlers.npc.RandomTPNPC;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PersonalRandomTPNPC
extends RandomTPNPC {
    public static NPC.Skin.Custom OVERWORLD_SKIN;
    public static NPC.Skin.Custom NETHER_SKIN;
    public static NPC.Skin.Custom END_SKIN;
    private PersonalTeleportationHandler<RandomTPNPC> handler = TeleportationHandler.registerPersonalHandler(TeleportationHandler.Type.NPC, this);

    public PersonalRandomTPNPC(Integer id, ConfigurationSection section) {
        super(id, RandomTPNPC.Type.PERSONAL, section);
    }

    @Override
    public TeleportationHandler<RandomTPNPC> getHandler() {
        return this.handler;
    }

    @Override
    public void setIdle(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        this.npc.setCustomGlowing(player, false);
        ArrayList<String> text = new ArrayList<String>();
        for (String s : MessagesManager.Message.PLAYERNPC_TEXT_PERSONAL_IDLE.getValue(player)) {
            text.add(MessagesManager.placeholder(s, Pair.of((Object)"world", (Object)this.getColoredAlias()), Pair.of((Object)"level", (Object)("" + this.getWorldOptions().getRequirementsLevelAmount())), Pair.of((Object)"price", (Object)("" + this.getWorldOptions().getPrice()))));
        }
        NPC.Personal personal = this.npc.getPersonal(player);
        personal.resetClickActions();
        personal.addCustomClickAction(NPC.Interact.ClickType.LEFT_CLICK, (npc1, player1) -> {
            if (!PermissionsManager.Permission.ADMIN.has((Player)player1)) {
                return;
            }
            if (!player1.isSneaking()) {
                MessagesManager.Message.PLAYERNPC_COMMAND_REMOVE_SHIFT.sendMessage((CommandSender)player1, new Pair[0]);
                return;
            }
            this.removeConfirmation((Player)player1);
        });
        personal.addCustomClickAction(NPC.Interact.ClickType.RIGHT_CLICK, (npc1, player1) -> {
            if (!player1.hasPermission(this.getPermission()) && !PermissionsManager.Permission.ADMIN.has((Player)player1) && ConfigValue.USE_PERMISSIONS.get().booleanValue()) {
                PermissionsManager.sendPermissionsMessage(player1);
                this.error((Player)player1);
                return;
            }
            if (SearchTask.isSearching(player1)) {
                MessagesManager.Message.TELEPORT_ALREADY.sendMessage((CommandSender)player1, new Pair[0]);
                this.error((Player)player1);
                return;
            }
            this.handler.confirmTeleport((Player)player1, this.getWorldOptions().getWorld(), this.getColoredAlias(), () -> this.updateSearchingNPC((Player)player1));
        });
        this.npc.setCustomText(player, text);
        this.npc.setCustomData(this.getStateID(player), "idle");
        this.npc.update(player);
    }

    private NPCLib.Registry.ID getStateID(Player player) {
        return NPCLib.Registry.ID.of((Plugin)RandomTeleportPlugin.getInstance(), (String)("state_" + player.getName()));
    }

    private void updateSearchingNPC(Player player) {
        SearchTask searchTask = SearchTask.getSearching(player);
        if (searchTask != null && searchTask.getHandler().equals(this.handler)) {
            this.setSearching(player);
        } else {
            this.error(player);
        }
    }

    @Override
    public void setSearching(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        this.npc.setCustomGlowing(player, this.getGlowingColor() != null);
        ArrayList<String> text = new ArrayList<String>();
        for (String s : MessagesManager.Message.PLAYERNPC_TEXT_PERSONAL_SEARCHING.getValue(player)) {
            text.add(MessagesManager.placeholder(s, Pair.of((Object)"world", (Object)this.getColoredAlias())));
        }
        NPC.Personal personal = this.npc.getPersonal(player);
        personal.resetClickActions();
        personal.addCustomClickAction(NPC.Interact.ClickType.LEFT_CLICK, (npc1, player1) -> {
            SearchTask searchTask = SearchTask.getSearching(player1);
            if (!searchTask.getHandler().equals(this.handler)) {
                this.setIdle((Player)player1);
                return;
            }
            searchTask.cancel((Player)player1, SearchTask.Reason.DECISION);
        });
        personal.addCustomClickAction(NPC.Interact.ClickType.RIGHT_CLICK, (npc1, player1) -> MessagesManager.Message.TELEPORT_WANT_CANCEL_NPC_PERSONAL.sendMessage((CommandSender)player1, new Pair[0]));
        this.npc.setCustomText(player, text);
        this.npc.setCustomData(this.getStateID(player), "searching");
        this.npc.update(player);
    }
}

