/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.teleportation.handlers.npc;

import com.mojang.datafixers.util.Pair;
import dev.sergiferry.playernpc.api.NPC;
import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.randomtp.RandomTeleportPlugin;
import dev.sergiferry.randomtp.messages.MessagesManager;
import dev.sergiferry.randomtp.player.PermissionsManager;
import dev.sergiferry.randomtp.teleportation.GroupTeleportationHandler;
import dev.sergiferry.randomtp.teleportation.SearchTask;
import dev.sergiferry.randomtp.teleportation.TeleportationHandler;
import dev.sergiferry.randomtp.teleportation.handlers.npc.RandomTPNPC;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class GroupRandomTPNPC
extends RandomTPNPC {
    public static NPC.Skin.Custom OVERWORLD_SKIN;
    public static NPC.Skin.Custom NETHER_SKIN;
    public static NPC.Skin.Custom END_SKIN;
    private State state;
    private BukkitTask bukkitTask;
    private Material material;
    private GroupTeleportationHandler<RandomTPNPC> handler;

    public GroupRandomTPNPC(Integer id, ConfigurationSection section) {
        super(id, RandomTPNPC.Type.GROUP, section);
        if (this.getCancelDistance() < 1.0) {
            this.setCancelDistance(5.0);
        }
        this.handler = TeleportationHandler.registerGroupHandler(TeleportationHandler.Type.NPC, this);
        this.updateBlock();
        this.state = State.IDLE;
        this.npc.setTextItemGlowing(true);
    }

    @Override
    public void setIdle(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        if (this.npc.hasCustomData(this.getSearchingID(player))) {
            this.npc.setCustomData(this.getSearchingID(player), null);
        }
        ArrayList text = new ArrayList();
        MessagesManager.Message.PLAYERNPC_TEXT_GROUP_IDLE.getValue(player).forEach(s -> text.add(MessagesManager.placeholder(s, Pair.of((Object)"world", (Object)this.getColoredAlias()))));
        NPC.Personal personal = this.npc.getPersonal(player);
        personal.resetClickActions();
        personal.addCustomClickAction(NPC.Interact.ClickType.LEFT_CLICK, (npc1, player1) -> {
            if (!PermissionsManager.Permission.ADMIN.has((Player)player1)) {
                return;
            }
            if (!player1.isSneaking()) {
                MessagesManager.Message.PLAYERNPC_COMMAND_REMOVE_SHIFT.sendMessage((CommandSender)player1, new Pair[0]);
                return;
            }
            this.removeConfirmation((Player)player1);
        });
        personal.addCustomClickAction(NPC.Interact.ClickType.RIGHT_CLICK, (npc1, player1) -> {
            if (this.state.equals((Object)State.SEARCHING)) {
                this.setSearching((Player)player1);
                return;
            }
            if (!this.isInBlock((Player)player1, true)) {
                MessagesManager.Message.TELEPORT_SAME_FLOOR_NPC_GROUP.sendMessage((CommandSender)player1, new Pair[0]);
                if (!this.npc.hasCustomTextItem(player)) {
                    this.npc.setCustomTextItem(player, new ItemStack(this.material));
                    this.npc.setCustomTextItemGlowing(player, true);
                    this.npc.forceUpdateText(player);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RandomTeleportPlugin.getInstance(), () -> {
                        if (!this.npc.hasPlayer(player)) {
                            return;
                        }
                        if (!this.npc.hasCustomTextItem(player)) {
                            return;
                        }
                        this.npc.resetCustomTextItem(player);
                        this.npc.forceUpdateText(player);
                    }, 60L);
                }
                return;
            }
            this.startSearch((Player)player1);
        });
        this.npc.resetCustomTextItem(player);
        this.npc.setCustomGlowing(player, false);
        this.npc.setCustomText(player, text);
        this.npc.update(player);
    }

    @Override
    public void setSearching(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        if (this.npc.hasCustomData(this.getSearchingID(player))) {
            return;
        }
        NPC.Personal personal = this.npc.getPersonal(player);
        personal.resetClickActions(NPC.Interact.ClickType.RIGHT_CLICK);
        personal.addCustomClickAction(NPC.Interact.ClickType.RIGHT_CLICK, (npc1, player1) -> {
            if (this.getPlayers().contains(player1)) {
                MessagesManager.Message.TELEPORT_WANT_CANCEL_NPC_GROUP.sendMessage((CommandSender)player1, new Pair[0]);
            } else {
                MessagesManager.Message.TELEPORT_SAME_FLOOR_NPC_GROUP.sendMessage((CommandSender)player1, new Pair[0]);
            }
        });
        this.npc.resetCustomTextItem(player);
        this.npc.setCustomGlowing(player, this.getGlowingColor() != null);
        this.npc.setCustomData(this.getSearchingID(player), "searching");
        this.npc.setCustomText(player, this.getSearchingText(player));
        this.npc.update(player);
    }

    private NPCLib.Registry.ID getSearchingID(Player player) {
        return NPCLib.Registry.ID.of((Plugin)RandomTeleportPlugin.getInstance(), (String)("searching_" + player.getName()));
    }

    public void updateSearchingText() {
        this.npc.getPlayers().forEach(x -> {
            this.npc.setCustomText(x, this.getSearchingText((Player)x));
            this.npc.simpleUpdateText(x);
        });
    }

    public List<String> getSearchingText(Player player) {
        ArrayList<String> text = new ArrayList<String>();
        if (this.getSearchTask().hasStarted()) {
            MessagesManager.Message.PLAYERNPC_TEXT_GROUP_SEARCHING.getValue(player).forEach(s -> text.add(MessagesManager.placeholder(s, Pair.of((Object)"world", (Object)this.getColoredAlias()), Pair.of((Object)"players", (Object)("" + this.getSearchTask().getPlayers().size())))));
        } else {
            MessagesManager.Message.PLAYERNPC_TEXT_GROUP_WAITING.getValue(player).forEach(s -> text.add(MessagesManager.placeholder(s, Pair.of((Object)"world", (Object)this.getColoredAlias()), Pair.of((Object)"players", (Object)("" + (2 - this.getPlayers().size()))))));
        }
        return text;
    }

    public SearchTask getSearchTask() {
        return this.handler.getSearchTask();
    }

    public List<Player> getPlayers() {
        return this.handler.getSearchTask().getPlayers();
    }

    public void startSearch(Player starter) {
        if (!this.state.equals((Object)State.IDLE)) {
            return;
        }
        this.state = State.SEARCHING;
        this.updateBlock();
        this.handler.registerSearch(starter, new SearchTask.Options(this.getDestination(), this.handler));
        this.bukkitTask = Bukkit.getScheduler().runTaskTimer((Plugin)RandomTeleportPlugin.getInstance(), () -> {
            if (!this.state.equals((Object)State.SEARCHING) || this.getSearchTask() == null) {
                this.bukkitTask.cancel();
                return;
            }
            this.checkPlayers();
        }, 10L, 10L);
        this.npc.setGroundParticles(true);
        this.npc.getPlayers().forEach(x -> this.setSearching((Player)x));
    }

    public void cancelSearch(SearchTask.Reason reason) {
        if (!this.state.equals((Object)State.SEARCHING)) {
            return;
        }
        this.state = State.IDLE;
        this.handler.cancelSearchTask(reason);
        this.bukkitTask.cancel();
        this.npc.setGroundParticles(false);
        this.npc.getPlayers().forEach(x -> this.setIdle((Player)x));
    }

    public boolean isInBlock(Player player) {
        return this.isInBlock(player, false);
    }

    public boolean isInBlock(Player player, boolean update) {
        if (update) {
            this.updateBlock();
        }
        if (!player.getLocation().getWorld().equals(this.getLocation().getWorld())) {
            return false;
        }
        if (player.getLocation().distance(this.getLocation()) >= this.getCancelDistance()) {
            return false;
        }
        Block ground = player.getLocation().getBlock().getRelative(BlockFace.DOWN);
        return ground.getType().equals((Object)this.material) || ground.getRelative(BlockFace.DOWN).getType().equals((Object)this.material);
    }

    public void updateBlock() {
        Material material = this.npc.getLocation().getBlock().getRelative(BlockFace.DOWN).getType();
        if (this.material != null && this.material.equals((Object)material)) {
            return;
        }
        this.material = material;
    }

    private void checkPlayers() {
        Double cancelDistance = RandomTPNPC.Value.CANCEL_DISTANCE.get(this);
        for (Entity near : this.getLocation().getWorld().getNearbyEntities(this.getLocation(), cancelDistance.doubleValue(), cancelDistance.doubleValue(), cancelDistance.doubleValue())) {
            Player playerNear;
            if (!(near instanceof Player) || !this.isInBlock(playerNear = (Player)near) || this.getPlayers().contains(playerNear)) continue;
            this.handler.registerSearch(playerNear, null);
            if (!this.getSearchTask().hasStarted()) {
                this.getSearchTask().start();
                for (Player playerSearching : this.getSearchTask().getPlayers()) {
                    MessagesManager.Message.TELEPORT_STARTED.sendMessage((CommandSender)playerSearching, new Pair[0]);
                }
            }
            this.updateSearchingText();
        }
        ArrayList<Player> remove = new ArrayList<Player>();
        for (Player player1 : this.getPlayers()) {
            if (!this.isInBlock(player1)) {
                remove.add(player1);
                continue;
            }
            if (this.getSearchTask().hasStarted()) continue;
            MessagesManager.Message.TELEPORT_WAITING.sendMessage((CommandSender)player1, new Pair[0]);
        }
        remove.forEach(x -> {
            if (this.getSearchTask().getPlayers().contains(x)) {
                this.getSearchTask().cancel((Player)x, SearchTask.Reason.DECISION);
                this.updateSearchingText();
            }
        });
        if (this.getSearchTask().getPlayers().isEmpty()) {
            this.cancelSearch(SearchTask.Reason.SUCCESS);
        }
    }

    public State getState() {
        return this.state;
    }

    @Override
    public TeleportationHandler<RandomTPNPC> getHandler() {
        return this.handler;
    }

    public static enum State {
        IDLE,
        SEARCHING;

    }
}

