/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.teleportation;

import dev.sergiferry.randomtp.RandomTeleportPlugin;
import dev.sergiferry.randomtp.config.ConfigManager;
import dev.sergiferry.randomtp.config.PathValue;
import dev.sergiferry.randomtp.integration.IntegrationsManager;
import dev.sergiferry.randomtp.utils.ColorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class WorldOptions {
    private static final Map<World, WorldOptions> MAP = new HashMap<World, WorldOptions>();
    private final World world;
    private boolean commandEnabled;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    @ColorUtils.Colored(colored=false)
    private String alias;
    private boolean preventProtectedRegions;
    private boolean preventNotLoadedChunks;
    private boolean preventNotGeneratedChunks;
    private String commandDestination;
    private Double price;
    private List<Material> preventBlocks;
    private List<Biome> preventBiomes;
    private int preventNearSearchLocation;
    private int preventNearOtherPlayers;
    private int preventNearWorldSpawn;
    private int requirementsLevelAmount;
    private boolean requirementsLevelSubtract;

    public static WorldOptions of(@Nonnull World world) {
        Validate.notNull((Object)world);
        return MAP.get(world);
    }

    public static WorldOptions of(@Nonnull String formattedName) {
        Validate.notNull((Object)formattedName);
        Optional<World> candidate = MAP.keySet().stream().filter(x -> WorldOptions.format(x).equalsIgnoreCase(formattedName)).findFirst();
        return candidate.isPresent() ? WorldOptions.of(candidate.get()) : null;
    }

    private static WorldOptions create(@Nonnull World world) {
        Validate.notNull((Object)world);
        MAP.putIfAbsent(world, new WorldOptions(world));
        return MAP.get(world);
    }

    public static boolean exists(@Nonnull World world) {
        Validate.notNull((Object)world);
        return MAP.containsKey(world);
    }

    public static String format(@Nonnull World world) {
        Validate.notNull((Object)world);
        return world.getName().toLowerCase();
    }

    public static boolean isValid(@Nonnull String worldName) {
        Validate.notNull((Object)worldName);
        return !worldName.contains(" ");
    }

    public static boolean isValid(@Nullable World world) {
        if (world == null) {
            return false;
        }
        return WorldOptions.isValid(world.getName());
    }

    public static void loadWorlds(FileConfiguration fileConfiguration) {
        Bukkit.getWorlds().stream().filter(x -> WorldOptions.isValid(x)).forEach(x -> WorldOptions.create(x));
        MAP.values().forEach(x -> x.load(fileConfiguration));
    }

    private WorldOptions(World world) {
        this.world = world;
        MAP.put(world, this);
    }

    public void load(FileConfiguration configuration) {
        String configSection = this.getConfigSectionPath();
        this.maxX = Value.COORDINATES_MAX_X.get(configuration, configSection);
        this.maxY = Value.COORDINATES_MAX_Y.get(configuration, configSection);
        this.maxZ = Value.COORDINATES_MAX_Z.get(configuration, configSection);
        this.minX = Value.COORDINATES_MIN_X.get(configuration, configSection);
        this.minY = Value.COORDINATES_MIN_Y.get(configuration, configSection);
        this.minZ = Value.COORDINATES_MIN_Z.get(configuration, configSection);
        this.alias = Value.ALIAS.get(configuration, configSection);
        this.preventNotGeneratedChunks = Value.PREVENT_CHUNKS_NOT_GENERATED.get(configuration, configSection);
        this.preventNotLoadedChunks = Value.PREVENT_CHUNKS_NOT_LOADED.get(configuration, configSection);
        this.preventProtectedRegions = Value.PREVENT_PROTECTED_REGIONS.get(configuration, configSection);
        this.preventNearOtherPlayers = Value.PREVENT_NEAR_OTHER_PLAYERS.get(configuration, configSection);
        this.preventNearSearchLocation = Value.PREVENT_NEAR_SEARCH_LOCATION.get(configuration, configSection);
        this.preventNearWorldSpawn = Value.PREVENT_NEAR_WORLD_SPAWN.get(configuration, configSection);
        this.commandEnabled = Value.COMMAND_ENABLED.get(configuration, configSection);
        this.commandDestination = Value.COMMAND_DESTINATION.get(configuration, configSection);
        this.price = Value.REQUIREMENTS_MONEY_AMOUNT.get(configuration, configSection);
        this.requirementsLevelAmount = Value.REQUIREMENTS_LEVEL_AMOUNT.get(configuration, configSection);
        this.requirementsLevelSubtract = Value.REQUIREMENTS_LEVEL_SUBTRACT.get(configuration, configSection);
        this.preventBlocks = new ArrayList<Material>();
        for (String blockName : Value.PREVENT_BLOCKS.get(configuration, configSection)) {
            Material material = null;
            try {
                material = Material.valueOf((String)blockName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (material == null) {
                Bukkit.getConsoleSender().sendMessage(RandomTeleportPlugin.getInstance().getPrefix() + "\u00a77Block not recognized as '\u00a7c" + blockName + "\u00a77' at world \u00a7a" + this.world.getName());
                Bukkit.getConsoleSender().sendMessage("\u00a77(Perhaps the block is correct, but in this server version it does not exist.)");
                continue;
            }
            if (this.preventBlocks.contains(material)) continue;
            this.preventBlocks.add(material);
        }
        this.preventBiomes = new ArrayList<Biome>();
        for (String biomeName : Value.PREVENT_BIOMES.get(configuration, configSection)) {
            Biome biome = null;
            try {
                biome = Biome.valueOf((String)biomeName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (biome == null) {
                Bukkit.getConsoleSender().sendMessage(RandomTeleportPlugin.getInstance().getPrefix() + "\u00a77Biome not recognized as '\u00a7c" + biomeName + "\u00a77' at world \u00a7a" + this.world.getName());
                Bukkit.getConsoleSender().sendMessage("\u00a77(Perhaps the biome is correct, but in this server version it does not exist.)");
                continue;
            }
            if (this.preventBiomes.contains(biome)) continue;
            this.preventBiomes.add(biome);
        }
    }

    protected ConfigurationSection getConfigSection() {
        return ConfigManager.CONFIG.getFileConfiguration().getConfigurationSection(this.getConfigSectionPath());
    }

    public String getConfigSectionPath() {
        return "worlds." + WorldOptions.format(this.world);
    }

    public World getWorld() {
        return this.world;
    }

    public boolean isCommandEnabled() {
        return this.commandEnabled;
    }

    public void setCommandEnabled(boolean enabled) {
        this.commandEnabled = enabled;
    }

    public int getMinX() {
        return this.minX;
    }

    public void setMinX(int minX) {
        this.minX = minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public void setMinY(int minY) {
        this.minY = minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public void setMinZ(int minZ) {
        this.minZ = minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public void setMaxX(int maxX) {
        this.maxX = maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public void setMaxY(int maxY) {
        this.maxY = maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public void setMaxZ(int maxZ) {
        this.maxZ = maxZ;
    }

    @ColorUtils.Colored(colored=false)
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(@ColorUtils.Colored(colored=false) String alias) {
        this.alias = alias;
    }

    public boolean isPreventNotGeneratedChunks() {
        return this.preventNotGeneratedChunks;
    }

    public void setPreventNotGeneratedChunks(boolean preventNotGeneratedChunks) {
        this.preventNotGeneratedChunks = preventNotGeneratedChunks;
    }

    public boolean isPreventProtectedRegions() {
        return this.preventProtectedRegions;
    }

    public void setPreventProtectedRegions(boolean preventProtectedRegions) {
        this.preventProtectedRegions = preventProtectedRegions;
    }

    public boolean isPreventNotLoadedChunks() {
        return this.preventNotLoadedChunks;
    }

    public void setPreventNotLoadedChunks(boolean preventNotLoadedChunks) {
        this.preventNotLoadedChunks = preventNotLoadedChunks;
    }

    public String getCommandDestination() {
        return this.commandDestination;
    }

    public void setCommandDestination(String commandDestination) {
        this.commandDestination = commandDestination;
    }

    public List<Material> getPreventBlocks() {
        return this.preventBlocks;
    }

    public void setPreventBlocks(List<Material> preventBlocks) {
        this.preventBlocks = preventBlocks;
    }

    public List<Biome> getPreventBiomes() {
        return this.preventBiomes;
    }

    public void setPreventBiomes(List<Biome> preventBiomes) {
        this.preventBiomes = preventBiomes;
    }

    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public int getPreventNearSearchLocation() {
        return this.preventNearSearchLocation;
    }

    public int getPreventNearOtherPlayers() {
        return this.preventNearOtherPlayers;
    }

    public int getPreventNearWorldSpawn() {
        return this.preventNearWorldSpawn;
    }

    public boolean hasRequirementNetherGone() {
        return this.world.getEnvironment().equals((Object)World.Environment.NETHER) && this.getConfigSection().getBoolean(Value.REQUIREMENTS_NETHER_HAVE_GONE_BEFORE.getPath());
    }

    public boolean hasRequirementEndGone() {
        return this.world.getEnvironment().equals((Object)World.Environment.THE_END) && this.getConfigSection().getBoolean(Value.REQUIREMENTS_END_HAVE_GONE_BEFORE.getPath());
    }

    public boolean hasRequirementEndDragon() {
        return this.world.getEnvironment().equals((Object)World.Environment.THE_END) && this.getConfigSection().getBoolean(Value.REQUIREMENTS_END_DEAD_ENDER_DRAGON.getPath());
    }

    public int getRequirementsLevelAmount() {
        return this.requirementsLevelAmount;
    }

    public boolean hasRequirementsLevelAmount() {
        return this.requirementsLevelAmount > 0;
    }

    public boolean hasRequirementsLevelSubtract() {
        return this.requirementsLevelSubtract;
    }

    public boolean hasCost() {
        return this.hasMoneyCost() || this.hasLevelCost();
    }

    public boolean hasMoneyCost() {
        return IntegrationsManager.isUsingVault() && this.price > 0.0;
    }

    public boolean hasLevelCost() {
        return this.hasRequirementsLevelSubtract() && this.hasRequirementsLevelAmount();
    }

    public static class Value<T>
    extends PathValue<T> {
        public static final Value<Integer> COORDINATES_MAX_X = new Value<Integer>("coordinates.max.x", Integer.class);
        public static final Value<Integer> COORDINATES_MAX_Y = new Value<Integer>("coordinates.max.y", Integer.class);
        public static final Value<Integer> COORDINATES_MAX_Z = new Value<Integer>("coordinates.max.z", Integer.class);
        public static final Value<Integer> COORDINATES_MIN_X = new Value<Integer>("coordinates.min.x", Integer.class);
        public static final Value<Integer> COORDINATES_MIN_Y = new Value<Integer>("coordinates.min.y", Integer.class);
        public static final Value<Integer> COORDINATES_MIN_Z = new Value<Integer>("coordinates.min.z", Integer.class);
        public static final Value<String> ALIAS = new Value<String>("alias", String.class);
        public static final Value<Boolean> PREVENT_CHUNKS_NOT_GENERATED = new Value<Boolean>("prevent.chunks.not-generated", Boolean.class);
        public static final Value<Boolean> PREVENT_CHUNKS_NOT_LOADED = new Value<Boolean>("prevent.chunks.not-loaded", Boolean.class);
        public static final Value<Boolean> PREVENT_PROTECTED_REGIONS = new Value<Boolean>("prevent.protected-regions", Boolean.class);
        public static final Value<Integer> PREVENT_NEAR_OTHER_PLAYERS = new Value<Integer>("prevent.near.other-players", Integer.class);
        public static final Value<Integer> PREVENT_NEAR_SEARCH_LOCATION = new Value<Integer>("prevent.near.search-location", Integer.class);
        public static final Value<Integer> PREVENT_NEAR_WORLD_SPAWN = new Value<Integer>("prevent.near.world-spawn", Integer.class);
        public static final Value<Boolean> COMMAND_ENABLED = new Value<Boolean>("command.enabled", Boolean.class);
        public static final Value<String> COMMAND_DESTINATION = new Value<String>("command.destination", String.class);
        public static final Value<ConfigurationSection> REQUIREMENTS = new Value<ConfigurationSection>("requirements", ConfigurationSection.class);
        public static final Value<Double> REQUIREMENTS_MONEY_AMOUNT = new Value<Double>("requirements.money.amount", Double.class);
        public static final Value<Integer> REQUIREMENTS_LEVEL_AMOUNT = new Value<Integer>("requirements.level.amount", Integer.class);
        public static final Value<Boolean> REQUIREMENTS_LEVEL_SUBTRACT = new Value<Boolean>("requirements.level.subtract", Boolean.class);
        public static final Value<Boolean> REQUIREMENTS_NETHER_HAVE_GONE_BEFORE = new Value<Boolean>("requirements.nether.have-gone-before", Boolean.class);
        public static final Value<Boolean> REQUIREMENTS_END_HAVE_GONE_BEFORE = new Value<Boolean>("requirements.end.have-gone-before", Boolean.class);
        public static final Value<Boolean> REQUIREMENTS_END_DEAD_ENDER_DRAGON = new Value<Boolean>("requirements.end.dead-ender-dragon", Boolean.class);
        public static final Value<List<String>> PREVENT_BLOCKS = new Value<List>("prevent.blocks", List.class);
        public static final Value<List<String>> PREVENT_BIOMES = new Value<List>("prevent.biomes", List.class);

        public Value(String path, Class<T> type) {
            super(path, type);
        }

        public String getPath(String section) {
            return section + "." + this.getPath();
        }

        @Override
        public T get(FileConfiguration configuration, String section) {
            return (T)configuration.getObject(section + "." + this.getPath(), this.getType());
        }
    }
}

