/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.teleportation;

import com.mojang.datafixers.util.Pair;
import dev.sergiferry.randomtp.api.events.PlayerStartSearchingRandomTPEvent;
import dev.sergiferry.randomtp.integration.IntegrationsManager;
import dev.sergiferry.randomtp.integration.integrations.Vault;
import dev.sergiferry.randomtp.messages.MessagesManager;
import dev.sergiferry.randomtp.player.PlayerManager;
import dev.sergiferry.randomtp.teleportation.GroupTeleportationHandler;
import dev.sergiferry.randomtp.teleportation.PersonalTeleportationHandler;
import dev.sergiferry.randomtp.teleportation.SearchTask;
import dev.sergiferry.randomtp.teleportation.WorldOptions;
import dev.sergiferry.randomtp.teleportation.handlers.npc.RandomTPNPC;
import dev.sergiferry.randomtp.utils.ColorUtils;
import dev.sergiferry.randomtp.utils.ItemBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class TeleportationHandler<T> {
    private static final Map<Object, TeleportationHandler> MAP = new HashMap<Object, TeleportationHandler>();
    private Type<T> type;
    private T value;

    public static <T> PersonalTeleportationHandler<T> registerPersonalHandler(@Nonnull Type<T> type, @Nonnull T value) {
        Validate.notNull(type);
        Validate.notNull(value);
        PersonalTeleportationHandler<T> personalTeleportationHandler = new PersonalTeleportationHandler<T>(type, value);
        MAP.putIfAbsent(value, personalTeleportationHandler);
        return personalTeleportationHandler;
    }

    public static <T> GroupTeleportationHandler<T> registerGroupHandler(@Nonnull Type<T> type, @Nonnull T value) {
        Validate.notNull(type);
        Validate.notNull(value);
        Validate.isTrue((boolean)type.allowGroupTP, (String)"This teleportation handler do not support GroupTP");
        GroupTeleportationHandler<T> groupTeleportationHandler = new GroupTeleportationHandler<T>(type, value);
        MAP.putIfAbsent(value, groupTeleportationHandler);
        return groupTeleportationHandler;
    }

    public static PersonalTeleportationHandler<Player> getPlayerPersonalHandler(Player player) {
        if (!TeleportationHandler.isTeleportationHandler(player)) {
            TeleportationHandler.registerPersonalHandler(Type.PLAYER, player);
        }
        return (PersonalTeleportationHandler)TeleportationHandler.getHandler(Type.PLAYER, player);
    }

    public static void unregisterTeleportationHandler(@Nonnull Object o) {
        Validate.notNull((Object)o);
        if (MAP.containsKey(o)) {
            MAP.remove(o);
        }
    }

    public static boolean isTeleportationHandler(Object o) {
        return MAP.containsKey(o);
    }

    public static Type getType(Object o) {
        return MAP.get(o).getType();
    }

    public static <T> TeleportationHandler<T> getHandler(@Nonnull Type<T> type, @Nonnull T value) {
        Validate.notNull(type);
        Validate.notNull(value);
        return MAP.getOrDefault(value, null);
    }

    protected TeleportationHandler(Type<T> type, T value) {
        this.type = type;
        this.value = value;
    }

    public Type<T> getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    public abstract boolean isGroupTeleport();

    public Location getLocation() {
        if (this.type.equals(Type.PLAYER)) {
            return ((Player)this.value).getLocation();
        }
        if (this.type.equals(Type.SIGN)) {
            return ((Sign)this.value).getLocation();
        }
        if (this.type.equals(Type.NPC)) {
            return ((RandomTPNPC)this.value).getLocation();
        }
        return null;
    }

    public Double getCancelDistance() {
        if (this.type.equals(Type.SIGN)) {
            return 10.0;
        }
        if (this.type.equals(Type.NPC)) {
            return ((RandomTPNPC)this.value).getCancelDistance();
        }
        return null;
    }

    public void unregister() {
        TeleportationHandler.unregisterTeleportationHandler(this.getValue());
    }

    public void confirmTeleport(Player player, World world, String alias, Runnable afterAction) {
        WorldOptions worldOptions = WorldOptions.of(world);
        if (worldOptions.hasCost()) {
            ArrayList<String> lore = new ArrayList<String>();
            String t = "\u00a7a\u2714";
            String f = "\u00a7c\u2718";
            lore.add("");
            if (worldOptions.hasMoneyCost()) {
                Vault.EconomyManager vaultManager = IntegrationsManager.getVault().getEconomyManager();
                boolean hasMoney = vaultManager.hasBalance(player, worldOptions.getPrice());
                lore.add((hasMoney ? t : f) + " " + MessagesManager.placeholderAndColor(MessagesManager.Message.GUI_CONFIRMATION_COST_PRICE, player, Pair.of((Object)"price", (Object)("" + worldOptions.getPrice()))));
            }
            if (worldOptions.hasLevelCost()) {
                boolean hasLevel = player.getLevel() >= worldOptions.getRequirementsLevelAmount();
                lore.add((hasLevel ? t : f) + " " + MessagesManager.placeholderAndColor(MessagesManager.Message.GUI_CONFIRMATION_COST_XP, player, Pair.of((Object)"levels", (Object)("" + worldOptions.getRequirementsLevelAmount()))));
            }
            PlayerManager.confirmAction(player, player1 -> {
                this.teleportTo((Player)player1, world);
                afterAction.run();
            }, MessagesManager.placeholder(MessagesManager.Message.GUI_CONFIRMATION_QUESTION_PAY_RTP, player, Pair.of((Object)"world", (Object)ColorUtils.color(alias != null ? alias : worldOptions.getAlias())))).setSlot(13, new ItemBuilder(Material.GOLD_INGOT).setName("\u00a7" + (worldOptions.hasMoneyCost() ? "e" : "6") + "\u00a7l" + MessagesManager.Message.GUI_CONFIRMATION_COST_TITLE.getValue(player)).setLore(lore).setEnchanted(worldOptions.hasLevelCost()).hideAttributes().getItemStack());
        } else {
            this.teleportTo(player, world);
            afterAction.run();
        }
    }

    public void teleportTo(Player player, World world) {
        PlayerStartSearchingRandomTPEvent playerStartSearchingRandomTPEvent;
        if (world == null) {
            MessagesManager.Message.WORLD_NO_EXIST.sendMessage((CommandSender)player, new Pair[0]);
            return;
        }
        if (SearchTask.isSearching(player)) {
            MessagesManager.Message.TELEPORT_ALREADY.sendMessage((CommandSender)player, new Pair[0]);
            return;
        }
        if (PlayerManager.getCooldown(player) > 0) {
            MessagesManager.Message.COOLDOWN_ALREADY.sendMessage((CommandSender)player, Pair.of((Object)"cooldown", (Object)PlayerManager.getCooldown(player).toString()));
            return;
        }
        WorldOptions worldOptions = WorldOptions.of(world);
        if (worldOptions == null) {
            MessagesManager.Message.WORLD_NO_CONFIG.sendMessage((CommandSender)player, new Pair[0]);
            return;
        }
        if (worldOptions.hasRequirementNetherGone() && !PlayerManager.hasAdvancement(player, "nether/root")) {
            MessagesManager.Message.WORLD_REQUIREMENT_NETHER_GONE.sendMessage((CommandSender)player, new Pair[0]);
            return;
        }
        if (worldOptions.hasRequirementEndGone() && !PlayerManager.hasAdvancement(player, "end/root")) {
            MessagesManager.Message.WORLD_REQUIREMENT_END_GONE.sendMessage((CommandSender)player, new Pair[0]);
            return;
        }
        if (worldOptions.hasRequirementEndDragon() && world.getEnderDragonBattle().getEnderDragon() != null && !world.getEnderDragonBattle().getEnderDragon().isDead()) {
            MessagesManager.Message.WORLD_REQUIREMENT_END_DRAGON.sendMessage((CommandSender)player, new Pair[0]);
            return;
        }
        if (worldOptions.hasRequirementsLevelAmount() && player.getLevel() < worldOptions.getRequirementsLevelAmount()) {
            MessagesManager.Message.WORLD_REQUIREMENT_LEVEL.sendMessage((CommandSender)player, Pair.of((Object)"level", (Object)("" + worldOptions.getRequirementsLevelAmount())));
            return;
        }
        if (IntegrationsManager.isUsingVault()) {
            Double price = worldOptions.getPrice();
            Vault.EconomyManager vaultManager = IntegrationsManager.getVault().getEconomyManager();
            if (!vaultManager.hasBalance(player, price)) {
                MessagesManager.Message.VAULT_NO_BALANCE.sendMessage((CommandSender)player, Pair.of((Object)"price", (Object)price.toString()), Pair.of((Object)"balance", (Object)vaultManager.getBalanceFormat(player)));
                return;
            }
        }
        if ((playerStartSearchingRandomTPEvent = new PlayerStartSearchingRandomTPEvent(player, this)).isCancelled()) {
            return;
        }
        MessagesManager.Message.TELEPORT_STARTED.sendMessage((CommandSender)player, new Pair[0]);
        this.registerSearch(player, new SearchTask.Options(world, this)).start();
    }

    public abstract SearchTask registerSearch(Player var1, SearchTask.Options var2);

    public abstract SearchTask unregisterSearch(Player var1);

    public abstract void cancelSearchTasks();

    public static class Type<T> {
        public static Type<Player> PLAYER = new Type(Player.class, false);
        public static Type<RandomTPNPC> NPC = new Type(RandomTPNPC.class, true);
        public static Type<Sign> SIGN = new Type(Sign.class, false);
        private Class<?> typeClass;
        private boolean allowGroupTP;

        public Type(Class<?> typeClass, boolean allowGroupTP) {
            this.typeClass = typeClass;
            this.allowGroupTP = allowGroupTP;
        }

        public Class<?> getTypeClass() {
            return this.typeClass;
        }

        public boolean isAllowGroupTP() {
            return this.allowGroupTP;
        }
    }
}

