/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.teleportation;

import com.mojang.datafixers.util.Pair;
import dev.sergiferry.randomtp.RandomTeleportPlugin;
import dev.sergiferry.randomtp.api.events.PlayerCancelRandomTPEvent;
import dev.sergiferry.randomtp.api.events.PlayerRandomTeleportEvent;
import dev.sergiferry.randomtp.config.ConfigValue;
import dev.sergiferry.randomtp.debug.DebugManager;
import dev.sergiferry.randomtp.integration.IntegrationsManager;
import dev.sergiferry.randomtp.integration.integrations.Vault;
import dev.sergiferry.randomtp.messages.MessagesManager;
import dev.sergiferry.randomtp.metrics.MetricsManager;
import dev.sergiferry.randomtp.player.PlayerManager;
import dev.sergiferry.randomtp.teleportation.FindLocation;
import dev.sergiferry.randomtp.teleportation.GroupTeleportationHandler;
import dev.sergiferry.randomtp.teleportation.TeleportationHandler;
import dev.sergiferry.randomtp.teleportation.WorldOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.milkbowl.vault.economy.EconomyResponse;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;

public class SearchTask {
    private static List<SearchTask> SEARCH_LIST = new ArrayList<SearchTask>();
    private TeleportationHandler handler;
    private Party party;
    private Options options;
    private BukkitTask bukkitTask;
    private Long startedSearch;
    private boolean found;
    private boolean testing;
    private CompletableFuture<Location> candidate;
    private AtomicInteger tries;

    public static SearchTask registerSearch(TeleportationHandler handler, Player player, Options options) {
        return new SearchTask(handler, player, options);
    }

    public static SearchTask getSearching(Player player) {
        return SEARCH_LIST.stream().filter(x -> x != null && x.getParty() != null && x.getParty().containsPlayer(player)).findAny().orElse(null);
    }

    public static SearchTask getSearching(GroupTeleportationHandler teleportationHandler) {
        return SEARCH_LIST.stream().filter(x -> x != null && x.getHandler() != null && x.getHandler().equals(teleportationHandler)).findAny().orElse(null);
    }

    public static boolean isSearching(Player player) {
        return SearchTask.getSearching(player) != null;
    }

    public static boolean isSearching(GroupTeleportationHandler teleportationHandler) {
        return SearchTask.getSearching(teleportationHandler) != null;
    }

    public static void cancelAll() {
        List.copyOf(SEARCH_LIST).stream().filter(x -> x != null).forEach(x -> x.cancel(Reason.ERROR));
        SEARCH_LIST = new ArrayList<SearchTask>();
    }

    private SearchTask(TeleportationHandler handler, Player player, Options options) {
        this.handler = handler;
        this.party = new Party();
        this.options = options;
        this.found = false;
        this.testing = false;
        this.candidate = null;
        this.tries = new AtomicInteger(0);
        options.searchTask = this;
        SEARCH_LIST.add(this);
        DebugManager.debug("Registered task with ID " + SEARCH_LIST.size() + (String)(player != null ? " for " + player.getName() : "") + (String)(handler != null ? " on handler " + handler.getType().getTypeClass().getSimpleName() : ""));
        this.joinPlayer(player);
    }

    public boolean hasStarted() {
        return this.bukkitTask != null || this.found;
    }

    public void start() {
        this.startedSearch = System.currentTimeMillis();
        this.bukkitTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)RandomTeleportPlugin.getInstance(), () -> {
            if ((System.currentTimeMillis() - this.startedSearch) / 1000L >= (long)ConfigValue.TELEPORT_TIMER_MAX_SEARCH.get().intValue()) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RandomTeleportPlugin.getInstance(), () -> this.cancel(Reason.NOT_FOUND));
                return;
            }
            if (this.handler.getCancelDistance() != null && this.handler.getCancelDistance() >= 1.0 && this.handler.getLocation() != null) {
                Location handlerLocation = this.handler.getLocation();
                Double cancelDistance = this.handler.getCancelDistance();
                for (Player players : this.getPlayers()) {
                    if (players.getLocation().getWorld().equals(handlerLocation.getWorld()) && !(players.getLocation().distance(handlerLocation) >= cancelDistance)) continue;
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RandomTeleportPlugin.getInstance(), () -> this.cancel(players, Reason.DECISION));
                }
            }
            this.getParty().sendMessage(MessagesManager.Message.TELEPORT_SEARCHING, new Pair[0]);
            if (ConfigValue.TELEPORT_EFFECT_SOUNDS.get().booleanValue()) {
                this.getParty().getPlayers().forEach(x -> x.playSound(x.getLocation(), Sound.BLOCK_BEACON_AMBIENT, 1.0f, 1.0f));
            }
            if (this.found || this.testing) {
                return;
            }
            this.tries.addAndGet(1);
            DebugManager.debug("Asked random location in try #" + this.tries.get());
            Long askedLong = System.currentTimeMillis();
            this.testing = true;
            this.candidate = FindLocation.getRandomLocation(this.options);
            this.candidate.thenAccept(random -> {
                WorldOptions worldOptions;
                DebugManager.debug("Received in " + (System.currentTimeMillis() - askedLong) + " ms");
                WorldOptions worldOptions2 = worldOptions = random != null ? WorldOptions.of(random.getWorld()) : null;
                if (worldOptions == null || worldOptions.isPreventProtectedRegions() && this.canPlace(this.party, (Location)random)) {
                    this.testing = false;
                    return;
                }
                this.finish((Location)random);
            });
        }, 40L, 40L);
    }

    public void finish(Location location) {
        DebugManager.debug("Found in: " + this.tries.get() + " tries");
        this.found = true;
        this.party.getPlayers().forEach(x -> this.finish(location, (Player)x));
        this.stopTask();
    }

    public void finish(Location random, Player player) {
        this.found = true;
        if (!this.handler.isGroupTeleport()) {
            if (PlayerManager.getCooldown(player) > 0) {
                MessagesManager.Message.COOLDOWN_ALREADY.sendMessage((CommandSender)player, Pair.of((Object)"cooldown", (Object)PlayerManager.getCooldown(player).toString()));
                this.cancel(player, Reason.ERROR);
                return;
            }
            WorldOptions worldOptions = WorldOptions.of(random.getWorld());
            Double price = worldOptions.getPrice();
            if (IntegrationsManager.isUsingVault() && price > 0.0) {
                Vault.EconomyManager vaultManager = IntegrationsManager.getVault().getEconomyManager();
                if (!vaultManager.hasBalance(player, price)) {
                    MessagesManager.Message.VAULT_NO_BALANCE.sendMessage((CommandSender)player, Pair.of((Object)"price", (Object)price.toString()), Pair.of((Object)"balance", (Object)vaultManager.getBalanceFormat(player)));
                    this.cancel(player, Reason.ERROR);
                    return;
                }
                EconomyResponse response = vaultManager.withdrawBalance(player, price);
                if (!response.transactionSuccess()) {
                    MessagesManager.Message.VAULT_ERROR.sendMessage((CommandSender)player, Pair.of((Object)"error", (Object)response.errorMessage));
                    this.cancel(player, Reason.ERROR);
                    return;
                }
                MessagesManager.Message.VAULT_SUCCESS.sendMessage((CommandSender)player, Pair.of((Object)"price", (Object)price.toString()), Pair.of((Object)"balance", (Object)vaultManager.getBalanceFormat(player)));
            }
            if (worldOptions.hasRequirementsLevelAmount()) {
                if (player.getLevel() < worldOptions.getRequirementsLevelAmount()) {
                    MessagesManager.Message.WORLD_REQUIREMENT_LEVEL.sendMessage((CommandSender)player, Pair.of((Object)"level", (Object)("" + worldOptions.getRequirementsLevelAmount())));
                    this.cancel(player, Reason.ERROR);
                    return;
                }
                if (worldOptions.hasRequirementsLevelSubtract()) {
                    MessagesManager.Message.WORLD_REQUIREMENT_LEVEL_SUCCESS.sendMessage((CommandSender)player, Pair.of((Object)"level", (Object)("" + worldOptions.getRequirementsLevelAmount())));
                    if (ConfigValue.TELEPORT_EFFECT_SOUNDS.get().booleanValue()) {
                        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.4f, 1.0f);
                    }
                    player.setLevel(Math.max(0, player.getLevel() - worldOptions.getRequirementsLevelAmount()));
                }
            }
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RandomTeleportPlugin.getInstance(), () -> {
            PlayerRandomTeleportEvent event = new PlayerRandomTeleportEvent(player, this, random, this.options);
            if (event.isCancelled()) {
                this.cancel(player, Reason.UNKNOWN);
                return;
            }
            this.cancel(player, Reason.SUCCESS);
            if (ConfigValue.TELEPORT_EFFECT_VISUAL.get().booleanValue()) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, Integer.MAX_VALUE, 1, false, false, false));
            }
            if (ConfigValue.TELEPORT_EFFECT_SOUNDS.get().booleanValue()) {
                player.playSound(player.getLocation(), Sound.BLOCK_PORTAL_TRAVEL, 0.1f, 1.0f);
            }
            MessagesManager.Message.TELEPORT_FOUND.sendMessage((CommandSender)player, new Pair[0]);
            Bukkit.getScheduler().runTaskLater((Plugin)RandomTeleportPlugin.getInstance(), () -> {
                player.teleport(random);
                if (ConfigValue.TELEPORT_EFFECT_SLOWNESS.get().booleanValue()) {
                    player.removePotionEffect(PotionEffectType.SLOW);
                }
                if (ConfigValue.TELEPORT_EFFECT_VISUAL.get().booleanValue()) {
                    player.removePotionEffect(PotionEffectType.BLINDNESS);
                    player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 1, false, false, false));
                }
                PlayerManager.setLastTeleport(player);
                MessagesManager.Message.TELEPORT_COMPLETE.sendMessage((CommandSender)player, new Pair[0]);
                MetricsManager.getRandomTPs().addCount(1);
                PlayerManager.setCooldown(player);
                random.getChunk().removePluginChunkTicket((Plugin)RandomTeleportPlugin.getInstance());
            }, 15L);
        });
    }

    public void cancel(Reason reason) {
        List.copyOf(this.party.getPlayers()).forEach(x -> this.cancel((Player)x, reason));
    }

    public void cancel(Player player, Reason reason) {
        boolean runningCandidate;
        boolean bl = runningCandidate = this.candidate != null && !this.candidate.isDone();
        if (this.candidate != null && this.party.getPlayers().size() == 1 && !this.candidate.isDone()) {
            this.candidate.cancel(true);
        }
        this.handler.unregisterSearch(player);
        if (reason.equals((Object)Reason.SUCCESS)) {
            return;
        }
        this.quitPlayer(player);
        if (reason.equals((Object)Reason.DECISION) && runningCandidate) {
            PlayerManager.setCooldown(player);
        }
        if (reason.equals((Object)Reason.NOT_FOUND)) {
            MessagesManager.Message.TELEPORT_NOT_FOUND.sendMessage((CommandSender)player, new Pair[0]);
        } else {
            MessagesManager.Message.TELEPORT_CANCELLED.sendMessage((CommandSender)player, new Pair[0]);
        }
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 0.6f);
        new PlayerCancelRandomTPEvent(player, this, reason);
        if (this.party.getPlayers().isEmpty()) {
            this.stopTask();
        }
    }

    public void stopTask() {
        if (this.bukkitTask != null) {
            this.bukkitTask.cancel();
        }
        this.bukkitTask = null;
        SEARCH_LIST.remove(this);
        DebugManager.debug("Unregistered task " + (String)(this.handler != null ? " on handler " + this.handler.getType().getTypeClass().getSimpleName() : "") + " (Total tasks: " + SEARCH_LIST.size() + ")");
    }

    protected void joinPlayer(Player player) {
        Validate.isTrue((!this.party.containsPlayer(player) ? 1 : 0) != 0);
        this.party.addPlayer(player);
        if (ConfigValue.TELEPORT_EFFECT_SLOWNESS.get().booleanValue()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, Integer.MAX_VALUE, 2, false, false, false));
        }
    }

    protected void quitPlayer(Player player) {
        Validate.isTrue((boolean)this.party.containsPlayer(player));
        this.party.removePlayer(player);
        if (ConfigValue.TELEPORT_EFFECT_SLOWNESS.get().booleanValue()) {
            player.removePotionEffect(PotionEffectType.SLOW);
        }
    }

    public boolean canPlace(Party party, Location location) {
        for (Player player : party.getPlayers()) {
            if (this.canPlace(player, location)) continue;
            return false;
        }
        return true;
    }

    public boolean canPlace(Player player, Location location) {
        BlockPlaceEvent placeEvent = new BlockPlaceEvent(location.getBlock(), location.getBlock().getState(), location.getBlock().getRelative(BlockFace.DOWN), new ItemStack(Material.STONE), player, true, EquipmentSlot.HAND);
        Bukkit.getPluginManager().callEvent((Event)placeEvent);
        if (placeEvent.isCancelled()) {
            return false;
        }
        placeEvent.setCancelled(true);
        return true;
    }

    public TeleportationHandler getHandler() {
        return this.handler;
    }

    public Party getParty() {
        return this.party;
    }

    public List<Player> getPlayers() {
        return this.party.getPlayers();
    }

    public Options getOptions() {
        return this.options;
    }

    public boolean isGroupTeleport() {
        return this.getHandler().isGroupTeleport();
    }

    public static class Options {
        @Nonnull
        private final World world;
        @Nonnull
        private final TeleportationHandler teleportationHandler;
        @Nonnull
        private SearchTask searchTask;

        public Options(@Nonnull World world, @Nonnull TeleportationHandler handler) {
            Validate.notNull((Object)world);
            this.world = world;
            this.teleportationHandler = handler;
        }

        @Nonnull
        public World getWorld() {
            return this.world;
        }

        @Nonnull
        public SearchTask getSearchTask() {
            return this.searchTask;
        }

        @Nonnull
        public TeleportationHandler getTeleportationHandler() {
            return this.teleportationHandler;
        }
    }

    protected static class Party {
        private List<Player> players = new ArrayList<Player>();

        public Party() {
        }

        public Party(Collection<Player> players) {
            this();
            players.addAll(players);
        }

        public List<Player> getPlayers() {
            return this.players;
        }

        public boolean containsPlayer(Player player) {
            return this.players.contains(player);
        }

        protected void addPlayer(Player player) {
            if (this.containsPlayer(player)) {
                return;
            }
            this.players.add(player);
        }

        protected void removePlayer(Player player) {
            if (!this.containsPlayer(player)) {
                return;
            }
            this.players.remove(player);
        }

        public void sendMessage(MessagesManager.Message message, Pair<String, String> ... placeholders) {
            this.players.forEach(x -> message.sendMessage((CommandSender)x, placeholders));
        }
    }

    public static enum Reason {
        ERROR,
        NOT_FOUND,
        SUCCESS,
        DECISION,
        UNKNOWN;

    }
}

