/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.teleportation;

import dev.sergiferry.randomtp.RandomTeleportPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class RandomLocation {
    private static final HashMap<World, List<RandomLocation>> SAVED_LOCATIONS = new HashMap();
    private Location location;
    private final Long foundMillis;
    private Long lastUsed;

    protected RandomLocation(@Nonnull Location location) {
        this.location = location;
        this.foundMillis = System.currentTimeMillis();
        this.lastUsed = null;
        location.getChunk().addPluginChunkTicket((Plugin)RandomTeleportPlugin.getInstance());
        SAVED_LOCATIONS.putIfAbsent(location.getWorld(), new ArrayList());
        SAVED_LOCATIONS.get(location.getWorld()).add(this);
    }

    public Long getFoundMillis() {
        return this.foundMillis;
    }

    public Location getLocation() {
        this.lastUsed = System.currentTimeMillis();
        return this.location;
    }

    public boolean canBeUsed() {
        return this.location != null;
    }

    public void remove() {
        if (this.location == null) {
            return;
        }
        this.location.getChunk().removePluginChunkTicket((Plugin)RandomTeleportPlugin.getInstance());
        this.location = null;
        if (SAVED_LOCATIONS.get(this.location.getWorld()).contains(this)) {
            SAVED_LOCATIONS.get(this.location.getWorld()).remove(this);
        }
    }
}

